/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.MetricsMasterSource;
import org.apache.hadoop.hbase.master.MetricsMasterWrapper;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;

@InterfaceAudience.Private
public class MetricsMasterSourceImpl
extends BaseSourceImpl
implements MetricsMasterSource {
    private final MetricsMasterWrapper masterWrapper;
    private MutableFastCounter clusterRequestsCounter;

    public MetricsMasterSourceImpl(MetricsMasterWrapper masterWrapper) {
        this("Server", "Metrics about HBase master server", "master", "Master,sub=Server", masterWrapper);
    }

    public MetricsMasterSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext, MetricsMasterWrapper masterWrapper) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.masterWrapper = masterWrapper;
    }

    @Override
    public void init() {
        super.init();
        this.clusterRequestsCounter = this.metricsRegistry.newCounter("clusterRequests", "", 0L);
    }

    public void incRequests(long inc) {
        this.clusterRequestsCounter.incr(inc);
    }

    @Override
    public void getMetrics(MetricsCollector metricsCollector, boolean all) {
        MetricsRecordBuilder metricsRecordBuilder = metricsCollector.addRecord(this.metricsName);
        if (this.masterWrapper != null) {
            metricsRecordBuilder.addGauge(Interns.info((String)"masterActiveTime", (String)"Master Active Time"), this.masterWrapper.getActiveTime()).addGauge(Interns.info((String)"masterStartTime", (String)"Master Start Time"), this.masterWrapper.getStartTime()).addGauge(Interns.info((String)"averageLoad", (String)"AverageLoad"), this.masterWrapper.getAverageLoad()).tag(Interns.info((String)"liveRegionServers", (String)"Names of live RegionServers"), this.masterWrapper.getRegionServers()).addGauge(Interns.info((String)"numRegionServers", (String)"Number of RegionServers"), this.masterWrapper.getNumRegionServers()).tag(Interns.info((String)"deadRegionServers", (String)"Names of dead RegionServers"), this.masterWrapper.getDeadRegionServers()).addGauge(Interns.info((String)"numDeadRegionServers", (String)"Number of dead RegionServers"), this.masterWrapper.getNumDeadRegionServers()).tag(Interns.info((String)"zookeeperQuorum", (String)"Zookeeper Quorum"), this.masterWrapper.getZookeeperQuorum()).tag(Interns.info((String)"serverName", (String)"Server Name"), this.masterWrapper.getServerName()).tag(Interns.info((String)"clusterId", (String)"Cluster Id"), this.masterWrapper.getClusterId()).tag(Interns.info((String)"isActiveMaster", (String)"Is Active Master"), String.valueOf(this.masterWrapper.getIsActiveMaster()));
        }
        this.metricsRegistry.snapshot(metricsRecordBuilder, all);
    }
}

