/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.client.api.impl.TimelineAuthenticator;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenSelector;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;
import org.codehaus.jackson.map.ObjectMapper;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TimelineClientImpl
extends TimelineClient {
    private static final Log LOG = LogFactory.getLog(TimelineClientImpl.class);
    private static final String RESOURCE_URI_STR = "/ws/v1/timeline/";
    private static final Joiner JOINER = Joiner.on((String)"");
    private static Options opts = new Options();
    private Client client;
    private URI resURI;
    private boolean isEnabled;
    private TimelineAuthenticatedURLConnectionFactory urlFactory;

    public TimelineClientImpl() {
        super(TimelineClientImpl.class.getName());
        DefaultClientConfig cc = new DefaultClientConfig();
        cc.getClasses().add(YarnJacksonJaxbJsonProvider.class);
        if (UserGroupInformation.isSecurityEnabled()) {
            this.urlFactory = new TimelineAuthenticatedURLConnectionFactory();
            this.client = new Client((ClientHandler)new URLConnectionClientHandler((HttpURLConnectionFactory)this.urlFactory), (ClientConfig)cc);
        } else {
            this.client = Client.create((ClientConfig)cc);
        }
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.isEnabled = conf.getBoolean("yarn.timeline-service.enabled", false);
        if (!this.isEnabled) {
            LOG.info((Object)"Timeline service is not enabled");
        } else {
            this.resURI = YarnConfiguration.useHttps((Configuration)conf) ? URI.create(JOINER.join((Object)"https://", (Object)conf.get("yarn.timeline-service.webapp.https.address", "0.0.0.0:8190"), new Object[]{RESOURCE_URI_STR})) : URI.create(JOINER.join((Object)"http://", (Object)conf.get("yarn.timeline-service.webapp.address", "0.0.0.0:8188"), new Object[]{RESOURCE_URI_STR}));
            if (UserGroupInformation.isSecurityEnabled()) {
                this.urlFactory.setService(TimelineUtils.buildTimelineTokenService((Configuration)conf));
            }
            LOG.info((Object)("Timeline service address: " + this.resURI));
        }
        super.serviceInit(conf);
    }

    @Override
    public TimelinePutResponse putEntities(TimelineEntity ... entities) throws IOException, YarnException {
        ClientResponse resp;
        if (!this.isEnabled) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Nothing will be put because timeline service is not enabled");
            }
            return new TimelinePutResponse();
        }
        TimelineEntities entitiesContainer = new TimelineEntities();
        entitiesContainer.addEntities(Arrays.asList(entities));
        try {
            resp = this.doPostingEntities(entitiesContainer);
        }
        catch (RuntimeException re) {
            String msg = "Failed to get the response from the timeline server.";
            LOG.error((Object)msg, (Throwable)re);
            throw re;
        }
        if (resp == null || resp.getClientResponseStatus() != ClientResponse.Status.OK) {
            String msg = "Failed to get the response from the timeline server.";
            LOG.error((Object)msg);
            if (LOG.isDebugEnabled() && resp != null) {
                String output = (String)resp.getEntity(String.class);
                LOG.debug((Object)("HTTP error code: " + resp.getStatus() + " Server response : \n" + output));
            }
            throw new YarnException(msg);
        }
        return (TimelinePutResponse)resp.getEntity(TimelinePutResponse.class);
    }

    @Override
    public Token<TimelineDelegationTokenIdentifier> getDelegationToken(String renewer) throws IOException, YarnException {
        return TimelineAuthenticator.getDelegationToken(this.resURI.toURL(), this.urlFactory.token, renewer);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public ClientResponse doPostingEntities(TimelineEntities entities) {
        WebResource webResource = this.client.resource(this.resURI);
        return (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
    }

    public static void main(String[] argv) throws Exception {
        String path;
        CommandLine cliParser = new GnuParser().parse(opts, argv);
        if (cliParser.hasOption("put") && (path = cliParser.getOptionValue("put")) != null && path.length() > 0) {
            TimelineClientImpl.putTimelineEntitiesInJSONFile(path);
            return;
        }
        TimelineClientImpl.printUsage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putTimelineEntitiesInJSONFile(String path) {
        File jsonFile = new File(path);
        if (!jsonFile.exists()) {
            System.out.println("Error: File [" + jsonFile.getAbsolutePath() + "] doesn't exist");
            return;
        }
        ObjectMapper mapper = new ObjectMapper();
        YarnJacksonJaxbJsonProvider.configObjectMapper((ObjectMapper)mapper);
        TimelineEntities entities = null;
        try {
            entities = (TimelineEntities)mapper.readValue(jsonFile, TimelineEntities.class);
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace(System.err);
            return;
        }
        YarnConfiguration conf = new YarnConfiguration();
        TimelineClient client = TimelineClient.createTimelineClient();
        client.init((Configuration)conf);
        client.start();
        try {
            TimelinePutResponse response;
            if (UserGroupInformation.isSecurityEnabled() && conf.getBoolean("yarn.timeline-service.enabled", false)) {
                Token<TimelineDelegationTokenIdentifier> token = client.getDelegationToken(UserGroupInformation.getCurrentUser().getUserName());
                UserGroupInformation.getCurrentUser().addToken(token);
            }
            if ((response = client.putEntities(entities.getEntities().toArray(new TimelineEntity[entities.getEntities().size()]))).getErrors().size() == 0) {
                System.out.println("Timeline data is successfully put");
            } else {
                for (TimelinePutResponse.TimelinePutError error : response.getErrors()) {
                    System.out.println("TimelineEntity [" + error.getEntityType() + ":" + error.getEntityId() + "] is not successfully put. Error code: " + error.getErrorCode());
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        finally {
            client.stop();
        }
    }

    private static void printUsage() {
        new HelpFormatter().printHelp("TimelineClient", opts);
    }

    static {
        opts.addOption("put", true, "Put the TimelineEntities in a JSON file");
        opts.getOption("put").setArgName("Path to the JSON file");
        opts.addOption("help", false, "Print usage");
    }

    private static class TimelineAuthenticatedURLConnectionFactory
    implements HttpURLConnectionFactory {
        private AuthenticatedURL.Token token = new AuthenticatedURL.Token();
        private TimelineAuthenticator authenticator = new TimelineAuthenticator();
        private Token<TimelineDelegationTokenIdentifier> dToken;
        private Text service;

        public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
            try {
                if (this.dToken == null) {
                    this.dToken = this.selectToken();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Timeline delegation token: " + this.dToken.toString()));
                    }
                }
                if (this.dToken != null) {
                    HashMap<String, String> params = new HashMap<String, String>();
                    TimelineAuthenticator.injectDelegationToken(params, this.dToken);
                    url = TimelineAuthenticator.appendParams(url, params);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("URL with delegation token: " + url));
                    }
                }
                return new AuthenticatedURL((Authenticator)this.authenticator).openConnection(url, this.token);
            }
            catch (AuthenticationException e) {
                LOG.error((Object)("Authentication failed when openning connection [" + url + "] with token [" + this.token + "]."), (Throwable)e);
                throw new IOException(e);
            }
        }

        private Token<TimelineDelegationTokenIdentifier> selectToken() {
            UserGroupInformation ugi;
            try {
                ugi = UserGroupInformation.getCurrentUser();
            }
            catch (IOException e) {
                String msg = "Error when getting the current user";
                LOG.error((Object)msg, (Throwable)e);
                throw new YarnRuntimeException(msg, (Throwable)e);
            }
            TimelineDelegationTokenSelector tokenSelector = new TimelineDelegationTokenSelector();
            return tokenSelector.selectToken(this.service, ugi.getCredentials().getAllTokens());
        }

        public void setService(Text service) {
            this.service = service;
        }
    }
}

