/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ECTopologyVerifierResult;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class ECTopologyVerifier {
    public static final Logger LOG = LoggerFactory.getLogger(ECTopologyVerifier.class);

    private ECTopologyVerifier() {
    }

    public static ECTopologyVerifierResult getECTopologyVerifierResult(DatanodeInfo[] report, Collection<ErasureCodingPolicy> policies) {
        int numOfRacks = ECTopologyVerifier.getNumberOfRacks(report);
        return ECTopologyVerifier.getECTopologyVerifierResult(numOfRacks, report.length, policies);
    }

    public static ECTopologyVerifierResult getECTopologyVerifierResult(int numOfRacks, int numOfDataNodes, Collection<ErasureCodingPolicy> policies) {
        int minDN = 0;
        int minRack = 0;
        for (ErasureCodingPolicy policy : policies) {
            int policyDN = policy.getNumDataUnits() + policy.getNumParityUnits();
            minDN = Math.max(minDN, policyDN);
            int policyRack = (int)Math.ceil((double)policyDN / (double)policy.getNumParityUnits());
            minRack = Math.max(minRack, policyRack);
        }
        if (minDN == 0 || minRack == 0) {
            String resultMessage = "No erasure coding policy is given.";
            LOG.trace(resultMessage);
            return new ECTopologyVerifierResult(true, resultMessage);
        }
        return ECTopologyVerifier.verifyECWithTopology(minDN, minRack, numOfRacks, numOfDataNodes, ECTopologyVerifier.getReadablePolicies(policies));
    }

    private static ECTopologyVerifierResult verifyECWithTopology(int minDN, int minRack, int numOfRacks, int numOfDataNodes, String readablePolicies) {
        if (numOfDataNodes < minDN) {
            String resultMessage = String.format("The number of DataNodes (%d) is less than the minimum required number of DataNodes (%d) for the erasure coding policies: %s", numOfDataNodes, minDN, readablePolicies);
            LOG.debug(resultMessage);
            return new ECTopologyVerifierResult(false, resultMessage);
        }
        if (numOfRacks < minRack) {
            String resultMessage = String.format("The number of racks (%d) is less than the minimum required number of racks (%d) for the erasure coding policies: %s", numOfRacks, minRack, readablePolicies);
            LOG.debug(resultMessage);
            return new ECTopologyVerifierResult(false, resultMessage);
        }
        return new ECTopologyVerifierResult(true, String.format("The cluster setup can support EC policies: %s", readablePolicies));
    }

    private static int getNumberOfRacks(DatanodeInfo[] report) {
        HashMap<String, Integer> racks = new HashMap<String, Integer>();
        for (DatanodeInfo dni : report) {
            Integer count = (Integer)racks.get(dni.getNetworkLocation());
            if (count == null) {
                count = 0;
            }
            racks.put(dni.getNetworkLocation(), count + 1);
        }
        return racks.size();
    }

    private static String getReadablePolicies(Collection<ErasureCodingPolicy> policies) {
        return policies.stream().map(policyInfo -> policyInfo.getName()).collect(Collectors.joining(", "));
    }
}

