/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.transform;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.cdc.common.data.RecordData;
import org.apache.flink.cdc.common.data.binary.BinaryRecordData;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.runtime.operators.transform.TableInfo;
import org.apache.flink.cdc.runtime.operators.transform.TransformExpressionCompiler;
import org.apache.flink.cdc.runtime.operators.transform.TransformExpressionKey;
import org.apache.flink.cdc.runtime.operators.transform.TransformFilter;
import org.apache.flink.cdc.runtime.parser.JaninoCompiler;
import org.apache.flink.cdc.runtime.typeutils.DataTypeConverter;
import org.codehaus.janino.ExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformFilterProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(TransformFilterProcessor.class);
    private TableInfo tableInfo;
    private TransformFilter transformFilter;
    private String timezone;
    private TransformExpressionKey transformExpressionKey;

    public TransformFilterProcessor(TableInfo tableInfo, TransformFilter transformFilter, String timezone) {
        this.tableInfo = tableInfo;
        this.transformFilter = transformFilter;
        this.timezone = timezone;
        this.transformExpressionKey = this.generateTransformExpressionKey();
    }

    public static TransformFilterProcessor of(TableInfo tableInfo, TransformFilter transformFilter, String timezone) {
        return new TransformFilterProcessor(tableInfo, transformFilter, timezone);
    }

    public boolean process(BinaryRecordData after, long epochTime) {
        ExpressionEvaluator expressionEvaluator = TransformExpressionCompiler.compileExpression(this.transformExpressionKey);
        try {
            return (Boolean)expressionEvaluator.evaluate(this.generateParams(after, epochTime));
        }
        catch (InvocationTargetException e) {
            LOG.error("Table:{} filter:{} execute failed. {}", new Object[]{this.tableInfo.getName(), this.transformFilter.getExpression(), e});
            throw new RuntimeException(e);
        }
    }

    private Object[] generateParams(BinaryRecordData after, long epochTime) {
        ArrayList<Object> params = new ArrayList<Object>();
        List columns = this.tableInfo.getSchema().getColumns();
        RecordData.FieldGetter[] fieldGetters = this.tableInfo.getFieldGetters();
        block0: for (String columnName : this.transformFilter.getColumnNames()) {
            if (columnName.equals("__namespace_name__")) {
                params.add(this.tableInfo.getNamespace());
                continue;
            }
            if (columnName.equals("__schema_name__")) {
                params.add(this.tableInfo.getSchemaName());
                continue;
            }
            if (columnName.equals("__table_name__")) {
                params.add(this.tableInfo.getTableName());
                continue;
            }
            for (int i = 0; i < columns.size(); ++i) {
                Column column = (Column)columns.get(i);
                if (!column.getName().equals(columnName)) continue;
                params.add(DataTypeConverter.convertToOriginal(fieldGetters[i].getFieldOrNull((RecordData)after), column.getType()));
                continue block0;
            }
        }
        params.add(this.timezone);
        params.add(epochTime);
        return params.toArray();
    }

    private TransformExpressionKey generateTransformExpressionKey() {
        ArrayList<String> argumentNames = new ArrayList<String>();
        ArrayList paramTypes = new ArrayList();
        List columns = this.tableInfo.getSchema().getColumns();
        String scriptExpression = this.transformFilter.getScriptExpression();
        List<String> columnNames = this.transformFilter.getColumnNames();
        block0: for (String columnName : columnNames) {
            for (int i = 0; i < columns.size(); ++i) {
                Column column = (Column)columns.get(i);
                if (!column.getName().equals(columnName)) continue;
                argumentNames.add(columnName);
                paramTypes.add(DataTypeConverter.convertOriginalClass(column.getType()));
                continue block0;
            }
        }
        if (scriptExpression.contains("__namespace_name__") && !argumentNames.contains("__namespace_name__")) {
            argumentNames.add("__namespace_name__");
            paramTypes.add(String.class);
        }
        if (scriptExpression.contains("__schema_name__") && !argumentNames.contains("__schema_name__")) {
            argumentNames.add("__schema_name__");
            paramTypes.add(String.class);
        }
        if (scriptExpression.contains("__table_name__") && !argumentNames.contains("__table_name__")) {
            argumentNames.add("__table_name__");
            paramTypes.add(String.class);
        }
        argumentNames.add("__time_zone__");
        paramTypes.add(String.class);
        argumentNames.add("__epoch_time__");
        paramTypes.add(Long.class);
        return TransformExpressionKey.of(JaninoCompiler.loadSystemFunction(scriptExpression), argumentNames, paramTypes, Boolean.class);
    }
}

