/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.shard;

import java.net.InetAddress;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.test.randomwalk.Fixture;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class ShardFixture
extends Fixture {
    static SortedSet<Text> genSplits(long max, int numTablets, String format) {
        long distance;
        int numSplits = numTablets - 1;
        long split = distance = max / (long)numTablets;
        TreeSet<Text> splits = new TreeSet<Text>();
        for (int i = 0; i < numSplits; ++i) {
            splits.add(new Text(String.format(format, split)));
            split += distance;
        }
        return splits;
    }

    static void createIndexTable(Logger log, State state, String suffix, Random rand) throws Exception {
        Connector conn = state.getConnector();
        String name = (String)state.get("indexTableName") + suffix;
        int numPartitions = (Integer)state.get("numPartitions");
        boolean enableCache = (Boolean)state.get("cacheIndex");
        conn.tableOperations().create(name);
        conn.tableOperations().addSplits(name, ShardFixture.genSplits(numPartitions, rand.nextInt(numPartitions) + 1, "%06x"));
        if (enableCache) {
            conn.tableOperations().setProperty(name, Property.TABLE_INDEXCACHE_ENABLED.getKey(), "true");
            conn.tableOperations().setProperty(name, Property.TABLE_BLOCKCACHE_ENABLED.getKey(), "true");
            log.info((Object)("Enabled caching for table " + name));
        }
    }

    @Override
    public void setUp(State state) throws Exception {
        String hostname = InetAddress.getLocalHost().getHostName().replaceAll("[-.]", "_");
        String pid = state.getPid();
        Random rand = new Random();
        int numPartitions = rand.nextInt(90) + 10;
        state.set("indexTableName", String.format("ST_index_%s_%s_%d", hostname, pid, System.currentTimeMillis()));
        state.set("docTableName", String.format("ST_docs_%s_%s_%d", hostname, pid, System.currentTimeMillis()));
        state.set("numPartitions", numPartitions);
        state.set("cacheIndex", rand.nextDouble() < 0.5);
        state.set("rand", rand);
        state.set("nextDocID", 0L);
        Connector conn = state.getConnector();
        ShardFixture.createIndexTable(this.log, state, "", rand);
        String docTableName = (String)state.get("docTableName");
        conn.tableOperations().create(docTableName);
        conn.tableOperations().addSplits(docTableName, ShardFixture.genSplits(255L, rand.nextInt(32) + 1, "%02x"));
        if (rand.nextDouble() < 0.5) {
            conn.tableOperations().setProperty((String)state.get("docTableName"), Property.TABLE_BLOOM_ENABLED.getKey(), "true");
            this.log.info((Object)("Enabled bloom filters for table " + (String)state.get("docTableName")));
        }
    }

    @Override
    public void tearDown(State state) throws Exception {
        if (state.isMultiTableBatchWriterInitialized()) {
            MultiTableBatchWriter mtbw = state.getMultiTableBatchWriter();
            try {
                mtbw.close();
            }
            catch (MutationsRejectedException e) {
                this.log.error((Object)"Ignoring mutations that weren't flushed", (Throwable)e);
            }
            state.resetMultiTableBatchWriter();
        }
        Connector conn = state.getConnector();
        conn.tableOperations().delete((String)state.get("indexTableName"));
        conn.tableOperations().delete((String)state.get("docTableName"));
        this.log.debug((Object)"Exiting shard test");
    }
}

