/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.shard;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.user.IntersectingIterator;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.hadoop.io.Text;

public class Search
extends Test {
    @Override
    public void visit(State state, Properties props) throws Exception {
        Random rand;
        String indexTableName = (String)state.get("indexTableName");
        String dataTableName = (String)state.get("docTableName");
        Map.Entry<Key, Value> entry = Search.findRandomDocument(state, dataTableName, rand = (Random)state.get("rand"));
        if (entry == null) {
            return;
        }
        Text docID = entry.getKey().getRow();
        String doc = entry.getValue().toString();
        String[] tokens = doc.split("\\W+");
        int numSearchTerms = rand.nextInt(6);
        if (numSearchTerms < 2) {
            numSearchTerms = 2;
        }
        HashSet<String> searchTerms = new HashSet<String>();
        while (searchTerms.size() < numSearchTerms) {
            searchTerms.add(tokens[rand.nextInt(tokens.length)]);
        }
        Text[] columns = new Text[searchTerms.size()];
        int index = 0;
        for (String term : searchTerms) {
            columns[index++] = new Text(term);
        }
        this.log.debug((Object)("Looking up terms " + searchTerms + " expect to find " + docID));
        BatchScanner bs = state.getConnector().createBatchScanner(indexTableName, Constants.NO_AUTHS, 10);
        IteratorSetting ii = new IteratorSetting(20, "ii", IntersectingIterator.class);
        IntersectingIterator.setColumnFamilies((IteratorSetting)ii, (Text[])columns);
        bs.addScanIterator(ii);
        bs.setRanges(Collections.singleton(new Range()));
        boolean sawDocID = false;
        for (Map.Entry entry2 : bs) {
            if (!((Key)entry2.getKey()).getColumnQualifier().equals((Object)docID)) continue;
            sawDocID = true;
            break;
        }
        bs.close();
        if (!sawDocID) {
            throw new Exception("Did not see doc " + docID + " in index.  terms:" + searchTerms + " " + indexTableName + " " + dataTableName);
        }
    }

    static Map.Entry<Key, Value> findRandomDocument(State state, String dataTableName, Random rand) throws Exception {
        Scanner scanner = state.getConnector().createScanner(dataTableName, Constants.NO_AUTHS);
        scanner.setBatchSize(1);
        scanner.setRange(new Range((CharSequence)Integer.toString(rand.nextInt(0xFFFFFFF), 16), null));
        Iterator iter = scanner.iterator();
        if (!iter.hasNext()) {
            return null;
        }
        return (Map.Entry)iter.next();
    }
}

