/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.shard;

import java.util.HashSet;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;

public class Insert
extends Test {
    static final int NUM_WORDS = 100000;
    static final int MIN_WORDS_PER_DOC = 10;
    static final int MAX_WORDS_PER_DOC = 3000;

    @Override
    public void visit(State state, Properties props) throws Exception {
        String indexTableName = (String)state.get("indexTableName");
        String dataTableName = (String)state.get("docTableName");
        int numPartitions = (Integer)state.get("numPartitions");
        Random rand = (Random)state.get("rand");
        long nextDocID = (Long)state.get("nextDocID");
        BatchWriter dataWriter = state.getMultiTableBatchWriter().getBatchWriter(dataTableName);
        BatchWriter indexWriter = state.getMultiTableBatchWriter().getBatchWriter(indexTableName);
        String docID = Insert.insertRandomDocument(nextDocID++, dataWriter, indexWriter, indexTableName, dataTableName, numPartitions, rand);
        this.log.debug((Object)("Inserted document " + docID));
        state.set("nextDocID", nextDocID);
    }

    static String insertRandomDocument(long did, BatchWriter dataWriter, BatchWriter indexWriter, String indexTableName, String dataTableName, int numPartitions, Random rand) throws TableNotFoundException, Exception, AccumuloException, AccumuloSecurityException {
        String doc = Insert.createDocument(rand);
        String docID = new StringBuilder(String.format("%016x", did)).reverse().toString();
        Insert.saveDocument(dataWriter, docID, doc);
        Insert.indexDocument(indexWriter, doc, docID, numPartitions);
        return docID;
    }

    static void saveDocument(BatchWriter bw, String docID, String doc) throws Exception {
        Mutation m = new Mutation((CharSequence)docID);
        m.put((CharSequence)"doc", (CharSequence)"", (CharSequence)doc);
        bw.addMutation(m);
    }

    static String createDocument(Random rand) {
        StringBuilder sb = new StringBuilder();
        int numWords = rand.nextInt(2990) + 10;
        for (int i = 0; i < numWords; ++i) {
            String word = Insert.generateRandomWord(rand);
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(word);
        }
        return sb.toString();
    }

    static String generateRandomWord(Random rand) {
        return Integer.toString(rand.nextInt(100000), 36);
    }

    static String genPartition(int partition) {
        return String.format("%06x", Math.abs(partition));
    }

    static void indexDocument(BatchWriter bw, String doc, String docId, int numPartitions) throws Exception {
        Insert.indexDocument(bw, doc, docId, numPartitions, false);
    }

    static void unindexDocument(BatchWriter bw, String doc, String docId, int numPartitions) throws Exception {
        Insert.indexDocument(bw, doc, docId, numPartitions, true);
    }

    static void indexDocument(BatchWriter bw, String doc, String docId, int numPartitions, boolean delete) throws Exception {
        String[] tokens = doc.split("\\W+");
        String partition = Insert.genPartition(doc.hashCode() % numPartitions);
        Mutation m = new Mutation((CharSequence)partition);
        HashSet<String> tokensSeen = new HashSet<String>();
        for (String token : tokens) {
            if (tokensSeen.contains(token = token.toLowerCase())) continue;
            tokensSeen.add(token);
            if (delete) {
                m.putDelete((CharSequence)token, (CharSequence)docId);
                continue;
            }
            m.put((CharSequence)token, (CharSequence)docId, new Value(new byte[0]));
        }
        if (m.size() > 0) {
            bw.addMutation(m);
        }
    }
}

