/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.shard;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.iterators.user.IntersectingIterator;
import org.apache.accumulo.core.iterators.user.RegExFilter;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.shard.Insert;
import org.apache.hadoop.io.Text;

public class Grep
extends Test {
    @Override
    public void visit(State state, Properties props) throws Exception {
        String indexTableName = (String)state.get("indexTableName");
        String dataTableName = (String)state.get("docTableName");
        Random rand = (Random)state.get("rand");
        Text[] words = new Text[rand.nextInt(4) + 2];
        for (int i = 0; i < words.length; ++i) {
            words[i] = new Text(Insert.generateRandomWord(rand));
        }
        BatchScanner bs = state.getConnector().createBatchScanner(indexTableName, Constants.NO_AUTHS, 16);
        IteratorSetting ii = new IteratorSetting(20, "ii", IntersectingIterator.class.getName());
        IntersectingIterator.setColumnFamilies((IteratorSetting)ii, (Text[])words);
        bs.addScanIterator(ii);
        bs.setRanges(Collections.singleton(new Range()));
        HashSet<Text> documentsFoundInIndex = new HashSet<Text>();
        for (Map.Entry entry2 : bs) {
            documentsFoundInIndex.add(((Key)entry2.getKey()).getColumnQualifier());
        }
        bs.close();
        bs = state.getConnector().createBatchScanner(dataTableName, Constants.NO_AUTHS, 16);
        for (int i = 0; i < words.length; ++i) {
            IteratorSetting more = new IteratorSetting(20 + i, "ii" + i, RegExFilter.class);
            RegExFilter.setRegexs((IteratorSetting)more, null, null, null, (String)("(^|(.*\\s))" + words[i] + "($|(\\s.*))"), (boolean)false);
            bs.addScanIterator(more);
        }
        bs.setRanges(Collections.singleton(new Range()));
        HashSet<Text> documentsFoundByGrep = new HashSet<Text>();
        for (Map.Entry entry2 : bs) {
            documentsFoundByGrep.add(((Key)entry2.getKey()).getRow());
        }
        bs.close();
        if (!documentsFoundInIndex.equals(documentsFoundByGrep)) {
            throw new Exception("Set of documents found not equal for words " + Arrays.asList(words).toString() + " " + documentsFoundInIndex + " " + documentsFoundByGrep);
        }
        this.log.debug((Object)("Grep and index agree " + Arrays.asList(words).toString() + " " + documentsFoundInIndex.size()));
    }
}

