/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.shard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchDeleter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.iterators.user.RegExFilter;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;

public class DeleteSomeDocs
extends Test {
    @Override
    public void visit(State state, Properties props) throws Exception {
        Random rand = (Random)state.get("rand");
        String indexTableName = (String)state.get("indexTableName");
        String dataTableName = (String)state.get("docTableName");
        ArrayList<String> patterns = new ArrayList<String>();
        for (Object key : props.keySet()) {
            if (!(key instanceof String) || !((String)key).startsWith("pattern")) continue;
            patterns.add(props.getProperty((String)key));
        }
        String pattern = (String)patterns.get(rand.nextInt(patterns.size()));
        BatchWriterConfig bwc = new BatchWriterConfig();
        BatchDeleter ibd = state.getConnector().createBatchDeleter(indexTableName, Constants.NO_AUTHS, 8, bwc);
        ibd.setRanges(Collections.singletonList(new Range()));
        IteratorSetting iterSettings = new IteratorSetting(100, RegExFilter.class);
        RegExFilter.setRegexs((IteratorSetting)iterSettings, null, null, (String)pattern, null, (boolean)false);
        ibd.addScanIterator(iterSettings);
        ibd.delete();
        ibd.close();
        BatchDeleter dbd = state.getConnector().createBatchDeleter(dataTableName, Constants.NO_AUTHS, 8, bwc);
        dbd.setRanges(Collections.singletonList(new Range()));
        iterSettings = new IteratorSetting(100, RegExFilter.class);
        RegExFilter.setRegexs((IteratorSetting)iterSettings, (String)pattern, null, null, null, (boolean)false);
        dbd.addScanIterator(iterSettings);
        dbd.delete();
        dbd.close();
        this.log.debug((Object)("Deleted documents w/ id matching '" + pattern + "'"));
    }
}

