/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.shard;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.iterators.user.RegExFilter;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.hadoop.io.Text;

public class CompactFilter
extends Test {
    @Override
    public void visit(State state, Properties props) throws Exception {
        String indexTableName = (String)state.get("indexTableName");
        String docTableName = (String)state.get("docTableName");
        Random rand = (Random)state.get("rand");
        String deleteChar = Integer.toHexString(rand.nextInt(16)) + "";
        String regex = "^[0-9a-f][" + deleteChar + "].*";
        ArrayList<IteratorSetting> documentFilters = new ArrayList<IteratorSetting>();
        IteratorSetting is = new IteratorSetting(21, "ii", RegExFilter.class);
        RegExFilter.setRegexs((IteratorSetting)is, (String)regex, null, null, null, (boolean)false);
        RegExFilter.setNegate((IteratorSetting)is, (boolean)true);
        documentFilters.add(is);
        long t1 = System.currentTimeMillis();
        state.getConnector().tableOperations().compact(docTableName, null, null, documentFilters, true, true);
        long t2 = System.currentTimeMillis();
        long t3 = t2 - t1;
        ArrayList<IteratorSetting> indexFilters = new ArrayList<IteratorSetting>();
        is = new IteratorSetting(21, RegExFilter.class);
        RegExFilter.setRegexs((IteratorSetting)is, null, null, (String)regex, null, (boolean)false);
        RegExFilter.setNegate((IteratorSetting)is, (boolean)true);
        indexFilters.add(is);
        t1 = System.currentTimeMillis();
        state.getConnector().tableOperations().compact(indexTableName, null, null, indexFilters, true, true);
        t2 = System.currentTimeMillis();
        this.log.debug((Object)("Filtered documents using compaction iterators " + regex + " " + t3 + " " + (t2 - t1)));
        BatchScanner bscanner = state.getConnector().createBatchScanner(docTableName, new Authorizations(), 10);
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (int i = 0; i < 16; ++i) {
            ranges.add(Range.prefix((Text)new Text(Integer.toHexString(i) + "" + deleteChar)));
        }
        bscanner.setRanges(ranges);
        Iterator iter = bscanner.iterator();
        if (iter.hasNext()) {
            throw new Exception("Saw unexpected document " + ((Map.Entry)iter.next()).getKey());
        }
        bscanner.close();
    }
}

