/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.sequential;

import java.net.InetAddress;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.test.randomwalk.Fixture;
import org.apache.accumulo.test.randomwalk.State;

public class SequentialFixture
extends Fixture {
    String seqTableName;

    @Override
    public void setUp(State state) throws Exception {
        Connector conn = state.getConnector();
        Instance instance = state.getInstance();
        String hostname = InetAddress.getLocalHost().getHostName().replaceAll("[-.]", "_");
        this.seqTableName = String.format("sequential_%s_%s_%d", hostname, state.getPid(), System.currentTimeMillis());
        state.set("seqTableName", this.seqTableName);
        try {
            conn.tableOperations().create(this.seqTableName);
            this.log.debug((Object)("Created table " + this.seqTableName + " (id:" + (String)Tables.getNameToIdMap((Instance)instance).get(this.seqTableName) + ")"));
        }
        catch (TableExistsException e) {
            this.log.warn((Object)("Table " + this.seqTableName + " already exists!"));
            throw e;
        }
        conn.tableOperations().setProperty(this.seqTableName, "table.scan.max.memory", "1K");
        state.set("numWrites", 0L);
        state.set("totalWrites", 0L);
    }

    @Override
    public void tearDown(State state) throws Exception {
        if (state.isMultiTableBatchWriterInitialized()) {
            MultiTableBatchWriter mtbw = state.getMultiTableBatchWriter();
            try {
                mtbw.close();
            }
            catch (MutationsRejectedException e) {
                this.log.error((Object)"Ignoring mutations that weren't flushed", (Throwable)e);
            }
            state.resetMultiTableBatchWriter();
        }
        this.log.debug((Object)("Dropping tables: " + this.seqTableName));
        Connector conn = state.getConnector();
        conn.tableOperations().delete(this.seqTableName);
    }
}

