/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.sequential;

import java.io.IOException;
import java.util.Iterator;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.Tool;
import org.apache.log4j.Logger;

public class MapRedVerifyTool
extends Configured
implements Tool {
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

    public int run(String[] args) throws Exception {
        Job job = new Job(this.getConf(), ((Object)((Object)this)).getClass().getSimpleName());
        job.setJarByClass(((Object)((Object)this)).getClass());
        if (job.getJar() == null) {
            this.log.error((Object)"M/R requires a jar file!  Run mvn package.");
            return 1;
        }
        job.setInputFormatClass(AccumuloInputFormat.class);
        AccumuloInputFormat.setConnectorInfo((Job)job, (String)args[0], (AuthenticationToken)new PasswordToken((CharSequence)args[1]));
        AccumuloInputFormat.setInputTableName((Job)job, (String)args[2]);
        AccumuloInputFormat.setZooKeeperInstance((Job)job, (String)args[3], (String)args[4]);
        job.setMapperClass(SeqMapClass.class);
        job.setMapOutputKeyClass(NullWritable.class);
        job.setMapOutputValueClass(IntWritable.class);
        job.setReducerClass(SeqReduceClass.class);
        job.setNumReduceTasks(1);
        job.setOutputFormatClass(AccumuloOutputFormat.class);
        AccumuloOutputFormat.setConnectorInfo((Job)job, (String)args[0], (AuthenticationToken)new PasswordToken((CharSequence)args[1]));
        AccumuloOutputFormat.setCreateTables((Job)job, (boolean)true);
        AccumuloOutputFormat.setDefaultTableName((Job)job, (String)args[5]);
        AccumuloOutputFormat.setZooKeeperInstance((Job)job, (String)args[3], (String)args[4]);
        job.waitForCompletion(true);
        return job.isSuccessful() ? 0 : 1;
    }

    public static class SeqReduceClass
    extends Reducer<NullWritable, IntWritable, Text, Mutation> {
        public void reduce(NullWritable ignore, Iterable<IntWritable> values, Reducer.Context output) throws IOException, InterruptedException {
            int start;
            Iterator<IntWritable> iterator = values.iterator();
            if (!iterator.hasNext()) {
                return;
            }
            int index = start = iterator.next().get();
            while (iterator.hasNext()) {
                int next = iterator.next().get();
                if (next != index + 1) {
                    this.writeMutation(output, start, index);
                    start = next;
                }
                index = next;
            }
            this.writeMutation(output, start, index);
        }

        public void writeMutation(Reducer.Context output, int start, int end) throws IOException, InterruptedException {
            Mutation m = new Mutation(new Text(String.format("%010d", start)));
            m.put(new Text(String.format("%010d", end)), new Text(""), new Value(new byte[0]));
            output.write(null, (Object)m);
        }
    }

    public static class SeqMapClass
    extends Mapper<Key, Value, NullWritable, IntWritable> {
        public void map(Key row, Value data, Mapper.Context output) throws IOException, InterruptedException {
            Integer num = Integer.valueOf(row.getRow().toString());
            output.write((Object)NullWritable.get(), (Object)new IntWritable(num.intValue()));
        }
    }
}

