/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.security;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.CredentialHelper;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.server.security.SecurityOperation;
import org.apache.accumulo.server.security.handler.Authenticator;
import org.apache.accumulo.server.security.handler.Authorizor;
import org.apache.accumulo.server.security.handler.PermissionHandler;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.log4j.Logger;

public class WalkingSecurity
extends SecurityOperation
implements Authorizor,
Authenticator,
PermissionHandler {
    State state = null;
    protected static final Logger log = Logger.getLogger(WalkingSecurity.class);
    private static final String tableName = "SecurityTableName";
    private static final String userName = "UserName";
    private static final String userPass = "UserPass";
    private static final String userExists = "UserExists";
    private static final String tableExists = "TableExists";
    private static final String connector = "UserConnection";
    private static final String authsMap = "authorizationsCountMap";
    private static final String lastKey = "lastMutationKey";
    private static final String filesystem = "securityFileSystem";
    private static WalkingSecurity instance = null;

    public WalkingSecurity(Authorizor author, Authenticator authent, PermissionHandler pm, String instanceId) {
        super(author, authent, pm, instanceId);
    }

    public WalkingSecurity(State state2) {
        super(state2.getInstance().getInstanceID());
        this.state = state2;
        this.authorizor = this;
        this.authenticator = this;
        this.permHandle = this;
    }

    public static WalkingSecurity get(State state) {
        if (instance == null || WalkingSecurity.instance.state != state) {
            instance = new WalkingSecurity(state);
            state.set(tableExists, Boolean.toString(false));
            state.set(authsMap, new HashMap());
        }
        return instance;
    }

    public void initialize(String instanceId, boolean initialize) {
        throw new UnsupportedOperationException("nope");
    }

    public boolean validSecurityHandlers(Authenticator one, PermissionHandler two) {
        return ((Object)((Object)this)).getClass().equals(one.getClass()) && ((Object)((Object)this)).getClass().equals(two.getClass());
    }

    public boolean validSecurityHandlers(Authenticator one, Authorizor two) {
        return ((Object)((Object)this)).getClass().equals(one.getClass()) && ((Object)((Object)this)).getClass().equals(two.getClass());
    }

    public boolean validSecurityHandlers(Authorizor one, PermissionHandler two) {
        return ((Object)((Object)this)).getClass().equals(one.getClass()) && ((Object)((Object)this)).getClass().equals(two.getClass());
    }

    public void initializeSecurity(TCredentials rootuser, String token) throws ThriftSecurityException {
        throw new UnsupportedOperationException("nope");
    }

    public void changeAuthorizations(String user, Authorizations authorizations) throws AccumuloSecurityException {
        this.state.set(user + "_auths", authorizations);
        this.state.set("Auths-" + user + '-' + "time", System.currentTimeMillis());
    }

    public Authorizations getCachedUserAuthorizations(String user) throws AccumuloSecurityException {
        return (Authorizations)this.state.get(user + "_auths");
    }

    public boolean ambiguousAuthorizations(String userName) {
        Long setTime = this.state.getLong("Auths-" + userName + '-' + "time");
        if (setTime == null) {
            throw new RuntimeException("WTF? Auths-" + userName + '-' + "time is null");
        }
        return System.currentTimeMillis() < setTime + 1000L;
    }

    public void initUser(String user) throws AccumuloSecurityException {
        this.changeAuthorizations(user, new Authorizations());
    }

    public Set<String> listUsers() throws AccumuloSecurityException {
        TreeSet<String> userList = new TreeSet<String>();
        for (String user : new String[]{this.getSysUserName(), this.getTabUserName()}) {
            if (!this.userExists(user)) continue;
            userList.add(user);
        }
        return userList;
    }

    public boolean authenticateUser(String principal, AuthenticationToken token) {
        PasswordToken pass = (PasswordToken)this.state.get(principal + userPass);
        boolean ret = pass.equals((Object)token);
        return ret;
    }

    public void createUser(String principal, AuthenticationToken token) throws AccumuloSecurityException {
        this.state.set(principal + userExists, Boolean.toString(true));
        this.changePassword(principal, token);
        this.cleanUser(principal);
    }

    public void dropUser(String user) throws AccumuloSecurityException {
        this.state.set(user + userExists, Boolean.toString(false));
        this.cleanUser(user);
        if (user.equals(this.getTabUserName())) {
            this.state.set("tableUserConnection", null);
        }
    }

    public void changePassword(String principal, AuthenticationToken token) throws AccumuloSecurityException {
        this.state.set(principal + userPass, token);
        this.state.set(principal + userPass + "time", System.currentTimeMillis());
    }

    public boolean userExists(String user) {
        return Boolean.parseBoolean(this.state.getString(user + userExists));
    }

    public boolean hasSystemPermission(String user, SystemPermission permission) throws AccumuloSecurityException {
        boolean res = Boolean.parseBoolean(this.state.getString("Sys-" + user + '-' + permission.name()));
        return res;
    }

    public boolean hasCachedSystemPermission(String user, SystemPermission permission) throws AccumuloSecurityException {
        return this.hasSystemPermission(user, permission);
    }

    public boolean hasTablePermission(String user, String table, TablePermission permission) throws AccumuloSecurityException, TableNotFoundException {
        return Boolean.parseBoolean(this.state.getString("Tab-" + user + '-' + permission.name()));
    }

    public boolean hasCachedTablePermission(String user, String table, TablePermission permission) throws AccumuloSecurityException, TableNotFoundException {
        return this.hasTablePermission(user, table, permission);
    }

    public void grantSystemPermission(String user, SystemPermission permission) throws AccumuloSecurityException {
        WalkingSecurity.setSysPerm(this.state, user, permission, true);
    }

    public void revokeSystemPermission(String user, SystemPermission permission) throws AccumuloSecurityException {
        WalkingSecurity.setSysPerm(this.state, user, permission, false);
    }

    public void grantTablePermission(String user, String table, TablePermission permission) throws AccumuloSecurityException, TableNotFoundException {
        this.setTabPerm(this.state, user, permission, table, true);
    }

    private static void setSysPerm(State state, String userName, SystemPermission tp, boolean value) {
        log.debug((Object)((value ? "Gave" : "Took") + " the system permission " + tp.name() + (value ? " to" : " from") + " user " + userName));
        state.set("Sys-" + userName + '-' + tp.name(), Boolean.toString(value));
    }

    private void setTabPerm(State state, String userName, TablePermission tp, String table, boolean value) {
        if (table.equals(userName)) {
            throw new RuntimeException("This is also fucked up");
        }
        log.debug((Object)((value ? "Gave" : "Took") + " the table permission " + tp.name() + (value ? " to" : " from") + " user " + userName));
        state.set("Tab-" + userName + '-' + tp.name(), Boolean.toString(value));
        if (tp.equals((Object)TablePermission.READ) || tp.equals((Object)TablePermission.WRITE)) {
            state.set("Tab-" + userName + '-' + tp.name() + '-' + "time", System.currentTimeMillis());
        }
    }

    public void revokeTablePermission(String user, String table, TablePermission permission) throws AccumuloSecurityException, TableNotFoundException {
        this.setTabPerm(this.state, user, permission, table, false);
    }

    public void cleanTablePermissions(String table) throws AccumuloSecurityException, TableNotFoundException {
        for (String user : new String[]{this.getSysUserName(), this.getTabUserName()}) {
            for (TablePermission tp : TablePermission.values()) {
                this.revokeTablePermission(user, table, tp);
            }
        }
        this.state.set(tableExists, Boolean.toString(false));
    }

    public void cleanUser(String user) throws AccumuloSecurityException {
        if (this.getTableExists()) {
            for (TablePermission tablePermission : TablePermission.values()) {
                try {
                    this.revokeTablePermission(user, this.getTableName(), tablePermission);
                }
                catch (TableNotFoundException e) {
                    // empty catch block
                }
            }
        }
        for (TablePermission tablePermission : SystemPermission.values()) {
            this.revokeSystemPermission(user, (SystemPermission)tablePermission);
        }
    }

    public String getTabUserName() {
        return this.state.getString("tableUserName");
    }

    public String getSysUserName() {
        return this.state.getString("systemUserName");
    }

    public void setTabUserName(String name) {
        this.state.set("tableUserName", name);
        this.state.set(name + userExists, Boolean.toString(false));
    }

    public void setSysUserName(String name) {
        this.state.set("systemUserName", name);
    }

    public String getTableName() {
        return this.state.getString(tableName);
    }

    public boolean getTableExists() {
        return Boolean.parseBoolean(this.state.getString(tableExists));
    }

    public TCredentials getSysCredentials() {
        return CredentialHelper.createSquelchError((String)this.getSysUserName(), (AuthenticationToken)this.getSysToken(), (String)this.state.getInstance().getInstanceID());
    }

    public TCredentials getTabCredentials() {
        return CredentialHelper.createSquelchError((String)this.getTabUserName(), (AuthenticationToken)this.getTabToken(), (String)this.state.getInstance().getInstanceID());
    }

    public AuthenticationToken getSysToken() {
        return new PasswordToken(this.getSysPassword());
    }

    public AuthenticationToken getTabToken() {
        return new PasswordToken(this.getTabPassword());
    }

    public byte[] getUserPassword(String user) {
        Object obj = this.state.get(user + userPass);
        if (obj instanceof PasswordToken) {
            return ((PasswordToken)obj).getPassword();
        }
        return null;
    }

    public byte[] getSysPassword() {
        Object obj = this.state.get(this.getSysUserName() + userPass);
        if (obj instanceof PasswordToken) {
            return ((PasswordToken)obj).getPassword();
        }
        return null;
    }

    public byte[] getTabPassword() {
        Object obj = this.state.get(this.getTabUserName() + userPass);
        if (obj instanceof PasswordToken) {
            return ((PasswordToken)obj).getPassword();
        }
        return null;
    }

    public boolean userPassTransient(String user) {
        return System.currentTimeMillis() - this.state.getLong(user + userPass + "time") < 1000L;
    }

    public void setTableName(String tName) {
        this.state.set(tableName, tName);
    }

    public void initTable(String table) throws AccumuloSecurityException {
        this.state.set(tableExists, Boolean.toString(true));
        this.state.set(tableName, table);
    }

    public String[] getAuthsArray() {
        return new String[]{"Fishsticks", "PotatoSkins", "Ribs", "Asparagus", "Paper", "Towels", "Lint", "Brush", "Celery"};
    }

    public boolean inAmbiguousZone(String userName, TablePermission tp) {
        if (tp.equals((Object)TablePermission.READ) || tp.equals((Object)TablePermission.WRITE)) {
            Long setTime = this.state.getLong("Tab-" + userName + '-' + tp.name() + '-' + "time");
            if (setTime == null) {
                throw new RuntimeException("WTF? Tab-" + userName + '-' + tp.name() + '-' + "time is null");
            }
            if (System.currentTimeMillis() < setTime + 1000L) {
                return true;
            }
        }
        return false;
    }

    public Map<String, Integer> getAuthsMap() {
        return (Map)this.state.get(authsMap);
    }

    public String getLastKey() {
        return this.state.getString(lastKey);
    }

    public void increaseAuthMap(String s, int increment) {
        Integer curVal = this.getAuthsMap().get(s);
        if (curVal == null) {
            curVal = 0;
            this.getAuthsMap().put(s, curVal);
        }
        curVal = curVal + increment;
    }

    public FileSystem getFs() {
        FileSystem fs = null;
        try {
            fs = (FileSystem)this.state.get(filesystem);
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        if (fs == null) {
            try {
                fs = FileSystem.get((Configuration)CachedConfiguration.getInstance());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.state.set(filesystem, fs);
        }
        return fs;
    }

    public boolean canAskAboutUser(TCredentials credentials, String user) throws ThriftSecurityException {
        try {
            return super.canAskAboutUser(credentials, user);
        }
        catch (ThriftSecurityException tse) {
            if (tse.getCode().equals((Object)SecurityErrorCode.PERMISSION_DENIED)) {
                return false;
            }
            throw tse;
        }
    }

    public boolean validTokenClass(String tokenClass) {
        return tokenClass.equals(PasswordToken.class.getCanonicalName());
    }

    public static void clearInstance() {
        instance = null;
    }

    public Set<Class<? extends AuthenticationToken>> getSupportedTokenTypes() {
        HashSet<Class<? extends AuthenticationToken>> cs = new HashSet<Class<? extends AuthenticationToken>>();
        cs.add(PasswordToken.class);
        return cs;
    }
}

