/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.security;

import java.net.InetAddress;
import java.util.Set;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.CredentialHelper;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.test.randomwalk.Fixture;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.security.Validate;
import org.apache.accumulo.test.randomwalk.security.WalkingSecurity;

public class SecurityFixture
extends Fixture {
    @Override
    public void setUp(State state) throws Exception {
        Set users;
        Connector conn = state.getConnector();
        String hostname = InetAddress.getLocalHost().getHostName().replaceAll("[-.]", "_");
        String systemUserName = String.format("system_%s", hostname);
        String tableUserName = String.format("table_%s", hostname);
        String secTableName = String.format("security_%s", hostname);
        if (conn.tableOperations().exists(secTableName)) {
            conn.tableOperations().delete(secTableName);
        }
        if ((users = conn.securityOperations().listLocalUsers()).contains(tableUserName)) {
            conn.securityOperations().dropLocalUser(tableUserName);
        }
        if (users.contains(systemUserName)) {
            conn.securityOperations().dropLocalUser(systemUserName);
        }
        PasswordToken sysUserPass = new PasswordToken((CharSequence)"sysUser");
        conn.securityOperations().createLocalUser(systemUserName, sysUserPass);
        WalkingSecurity.get(state).setTableName(secTableName);
        state.set("rootUserPass", CredentialHelper.extractToken((TCredentials)state.getCredentials()));
        WalkingSecurity.get(state).setSysUserName(systemUserName);
        WalkingSecurity.get(state).createUser(systemUserName, (AuthenticationToken)sysUserPass);
        WalkingSecurity.get(state).changePassword(tableUserName, (AuthenticationToken)new PasswordToken(new byte[0]));
        WalkingSecurity.get(state).setTabUserName(tableUserName);
        for (TablePermission tablePermission : TablePermission.values()) {
            WalkingSecurity.get(state).revokeTablePermission(systemUserName, secTableName, tablePermission);
            WalkingSecurity.get(state).revokeTablePermission(tableUserName, secTableName, tablePermission);
        }
        for (TablePermission tablePermission : SystemPermission.values()) {
            WalkingSecurity.get(state).revokeSystemPermission(systemUserName, (SystemPermission)tablePermission);
            WalkingSecurity.get(state).revokeSystemPermission(tableUserName, (SystemPermission)tablePermission);
        }
        WalkingSecurity.get(state).changeAuthorizations(tableUserName, new Authorizations());
    }

    @Override
    public void tearDown(State state) throws Exception {
        this.log.debug((Object)"One last validate");
        Validate.validate(state, this.log);
        Connector conn = state.getConnector();
        if (WalkingSecurity.get(state).getTableExists()) {
            String secTableName = WalkingSecurity.get(state).getTableName();
            this.log.debug((Object)("Dropping tables: " + secTableName));
            conn.tableOperations().delete(secTableName);
        }
        if (WalkingSecurity.get(state).userExists(WalkingSecurity.get(state).getTabUserName())) {
            String tableUserName = WalkingSecurity.get(state).getTabUserName();
            this.log.debug((Object)("Dropping user: " + tableUserName));
            conn.securityOperations().dropLocalUser(tableUserName);
        }
        String systemUserName = WalkingSecurity.get(state).getSysUserName();
        this.log.debug((Object)("Dropping user: " + systemUserName));
        conn.securityOperations().dropLocalUser(systemUserName);
        WalkingSecurity.clearInstance();
    }
}

