/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.security;

import java.util.Properties;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.security.WalkingSecurity;

public class DropUser
extends Test {
    @Override
    public void visit(State state, Properties props) throws Exception {
        Connector conn = state.getInstance().getConnector(WalkingSecurity.get(state).getSysUserName(), WalkingSecurity.get(state).getSysToken());
        String tableUserName = WalkingSecurity.get(state).getTabUserName();
        boolean exists = WalkingSecurity.get(state).userExists(tableUserName);
        boolean hasPermission = WalkingSecurity.get(state).canDropUser(WalkingSecurity.get(state).getSysCredentials(), tableUserName);
        try {
            conn.securityOperations().dropLocalUser(tableUserName);
        }
        catch (AccumuloSecurityException ae) {
            switch (ae.getSecurityErrorCode()) {
                case PERMISSION_DENIED: {
                    if (hasPermission) {
                        throw new AccumuloException("Got a security exception when I should have had permission.", (Throwable)ae);
                    }
                    if (exists) {
                        state.getConnector().securityOperations().dropLocalUser(tableUserName);
                        WalkingSecurity.get(state).dropUser(tableUserName);
                    }
                    return;
                }
                case USER_DOESNT_EXIST: {
                    if (exists) {
                        throw new AccumuloException("Got user DNE exception when user should exists.", (Throwable)ae);
                    }
                    return;
                }
            }
            throw new AccumuloException("Got unexpected exception", (Throwable)ae);
        }
        WalkingSecurity.get(state).dropUser(tableUserName);
        if (!hasPermission) {
            throw new AccumuloException("Didn't get Security Exception when we should have");
        }
    }
}

