/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.security;

import java.util.Properties;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.security.CredentialHelper;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.security.WalkingSecurity;

public class DropTable
extends Test {
    @Override
    public void visit(State state, Properties props) throws Exception {
        DropTable.dropTable(state, props);
    }

    public static void dropTable(State state, Properties props) throws Exception {
        AuthenticationToken token;
        String principal;
        String sourceUser = props.getProperty("source", "system");
        if (sourceUser.equals("table")) {
            principal = WalkingSecurity.get(state).getTabUserName();
            token = WalkingSecurity.get(state).getTabToken();
        } else {
            principal = WalkingSecurity.get(state).getSysUserName();
            token = WalkingSecurity.get(state).getSysToken();
        }
        Connector conn = state.getInstance().getConnector(principal, token);
        String tableName = WalkingSecurity.get(state).getTableName();
        boolean exists = WalkingSecurity.get(state).getTableExists();
        boolean hasPermission = WalkingSecurity.get(state).canDeleteTable(CredentialHelper.create((String)principal, (AuthenticationToken)token, (String)state.getInstance().getInstanceID()), tableName);
        try {
            conn.tableOperations().delete(tableName);
        }
        catch (AccumuloSecurityException ae) {
            if (ae.getSecurityErrorCode().equals((Object)SecurityErrorCode.PERMISSION_DENIED)) {
                if (hasPermission) {
                    throw new AccumuloException("Got a security exception when I should have had permission.", (Throwable)ae);
                }
                state.getConnector().tableOperations().delete(tableName);
                WalkingSecurity.get(state).cleanTablePermissions(tableName);
                return;
            }
            if (ae.getSecurityErrorCode().equals((Object)SecurityErrorCode.BAD_CREDENTIALS) && WalkingSecurity.get(state).userPassTransient(conn.whoami())) {
                return;
            }
            throw new AccumuloException("Got unexpected ae error code", (Throwable)ae);
        }
        catch (TableNotFoundException tnfe) {
            if (exists) {
                throw new TableExistsException(null, tableName, "Got a TableNotFOundException but it should have existed", (Throwable)tnfe);
            }
            return;
        }
        WalkingSecurity.get(state).cleanTablePermissions(tableName);
        if (!hasPermission) {
            throw new AccumuloException("Didn't get Security Exception when we should have");
        }
    }
}

