/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.security;

import java.util.Properties;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.security.WalkingSecurity;

public class CreateUser
extends Test {
    @Override
    public void visit(State state, Properties props) throws Exception {
        Connector conn = state.getInstance().getConnector(WalkingSecurity.get(state).getSysUserName(), WalkingSecurity.get(state).getSysToken());
        String tableUserName = WalkingSecurity.get(state).getTabUserName();
        boolean exists = WalkingSecurity.get(state).userExists(tableUserName);
        boolean hasPermission = WalkingSecurity.get(state).canCreateUser(WalkingSecurity.get(state).getSysCredentials(), tableUserName);
        PasswordToken tabUserPass = new PasswordToken((CharSequence)"Super Sekret Table User Password");
        try {
            conn.securityOperations().createLocalUser(tableUserName, tabUserPass);
        }
        catch (AccumuloSecurityException ae) {
            switch (ae.getSecurityErrorCode()) {
                case PERMISSION_DENIED: {
                    if (hasPermission) {
                        throw new AccumuloException("Got a security exception when I should have had permission.", (Throwable)ae);
                    }
                    if (!exists) {
                        state.getConnector().securityOperations().createLocalUser(tableUserName, tabUserPass);
                        WalkingSecurity.get(state).createUser(tableUserName, (AuthenticationToken)tabUserPass);
                        Thread.sleep(1000L);
                    }
                    return;
                }
                case USER_EXISTS: {
                    if (!exists) {
                        throw new AccumuloException("Got security exception when the user shouldn't have existed", (Throwable)ae);
                    }
                    return;
                }
            }
            throw new AccumuloException("Got unexpected exception", (Throwable)ae);
        }
        WalkingSecurity.get(state).createUser(tableUserName, (AuthenticationToken)tabUserPass);
        Thread.sleep(1000L);
        if (!hasPermission) {
            throw new AccumuloException("Didn't get Security Exception when we should have");
        }
    }
}

