/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.security;

import java.util.Properties;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.security.WalkingSecurity;

public class CreateTable
extends Test {
    @Override
    public void visit(State state, Properties props) throws Exception {
        Connector conn = state.getInstance().getConnector(WalkingSecurity.get(state).getSysUserName(), WalkingSecurity.get(state).getSysToken());
        String tableName = WalkingSecurity.get(state).getTableName();
        boolean exists = WalkingSecurity.get(state).getTableExists();
        boolean hasPermission = WalkingSecurity.get(state).canCreateTable(WalkingSecurity.get(state).getSysCredentials());
        try {
            conn.tableOperations().create(tableName);
        }
        catch (AccumuloSecurityException ae) {
            if (ae.getSecurityErrorCode().equals((Object)SecurityErrorCode.PERMISSION_DENIED)) {
                if (hasPermission) {
                    throw new AccumuloException("Got a security exception when I should have had permission.", (Throwable)ae);
                }
                try {
                    state.getConnector().tableOperations().create(tableName);
                    WalkingSecurity.get(state).initTable(tableName);
                }
                catch (TableExistsException tee) {
                    if (exists) {
                        return;
                    }
                    throw new AccumuloException("Test and Accumulo are out of sync");
                }
                return;
            }
            throw new AccumuloException("Got unexpected error", (Throwable)ae);
        }
        catch (TableExistsException tee) {
            if (!exists) {
                throw new TableExistsException(null, tableName, "Got a TableExistsException but it shouldn't have existed", (Throwable)tee);
            }
            return;
        }
        WalkingSecurity.get(state).initTable(tableName);
        for (TablePermission tp : TablePermission.values()) {
            WalkingSecurity.get(state).grantTablePermission(conn.whoami(), tableName, tp);
        }
        if (!hasPermission) {
            throw new AccumuloException("Didn't get Security Exception when we should have");
        }
    }
}

