/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.security;

import java.util.Arrays;
import java.util.Properties;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.security.CredentialHelper;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.security.WalkingSecurity;

public class Authenticate
extends Test {
    @Override
    public void visit(State state, Properties props) throws Exception {
        Authenticate.authenticate(WalkingSecurity.get(state).getSysUserName(), WalkingSecurity.get(state).getSysToken(), state, props);
    }

    public static void authenticate(String principal, AuthenticationToken token, State state, Properties props) throws Exception {
        boolean result;
        String targetProp = props.getProperty("target");
        boolean success = Boolean.parseBoolean(props.getProperty("valid"));
        Connector conn = state.getInstance().getConnector(principal, token);
        String target = targetProp.equals("table") ? WalkingSecurity.get(state).getTabUserName() : WalkingSecurity.get(state).getSysUserName();
        boolean exists = WalkingSecurity.get(state).userExists(target);
        byte[] password = Arrays.copyOf(WalkingSecurity.get(state).getUserPassword(target), WalkingSecurity.get(state).getUserPassword(target).length);
        boolean hasPermission = WalkingSecurity.get(state).canAskAboutUser(CredentialHelper.create((String)principal, (AuthenticationToken)token, (String)state.getInstance().getInstanceID()), target);
        if (!success) {
            int i = 0;
            while (i < password.length) {
                int n = i++;
                password[n] = (byte)(password[n] + 1);
            }
        }
        try {
            result = conn.securityOperations().authenticateUser(target, (AuthenticationToken)new PasswordToken(password));
        }
        catch (AccumuloSecurityException ae) {
            switch (ae.getSecurityErrorCode()) {
                case PERMISSION_DENIED: {
                    if (exists && hasPermission) {
                        throw new AccumuloException("Got a security exception when I should have had permission.", (Throwable)ae);
                    }
                    return;
                }
            }
            throw new AccumuloException("Unexpected exception!", (Throwable)ae);
        }
        if (!hasPermission) {
            throw new AccumuloException("Didn't get Security Exception when we should have");
        }
        if (result != (success && exists)) {
            throw new AccumuloException("Authentication " + (result ? "succeeded" : "failed") + " when it should have " + (success && exists ? "succeeded" : "failed") + " while the user exists? " + exists);
        }
    }
}

