/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.security;

import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.security.CredentialHelper;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.security.WalkingSecurity;

public class AlterTablePerm
extends Test {
    @Override
    public void visit(State state, Properties props) throws Exception {
        AlterTablePerm.alter(state, props);
    }

    public static void alter(State state, Properties props) throws Exception {
        AuthenticationToken sourceToken;
        String sourceUser;
        TablePermission tabPerm;
        String action = props.getProperty("task", "toggle");
        String perm = props.getProperty("perm", "random");
        String sourceUserProp = props.getProperty("source", "system");
        String targetUser = props.getProperty("target", "table");
        boolean tabExists = WalkingSecurity.get(state).getTableExists();
        String target = "table".equals(targetUser) ? WalkingSecurity.get(state).getTabUserName() : WalkingSecurity.get(state).getSysUserName();
        boolean exists = WalkingSecurity.get(state).userExists(target);
        boolean tableExists = WalkingSecurity.get(state).getTableExists();
        if (perm.equals("random")) {
            Random r = new Random();
            int i = r.nextInt(TablePermission.values().length);
            tabPerm = TablePermission.values()[i];
        } else {
            tabPerm = TablePermission.valueOf((String)perm);
        }
        String tableName = WalkingSecurity.get(state).getTableName();
        boolean hasPerm = WalkingSecurity.get(state).hasTablePermission(target, tableName, tabPerm);
        if ("system".equals(sourceUserProp)) {
            sourceUser = WalkingSecurity.get(state).getSysUserName();
            sourceToken = WalkingSecurity.get(state).getSysToken();
        } else if ("table".equals(sourceUserProp)) {
            sourceUser = WalkingSecurity.get(state).getTabUserName();
            sourceToken = WalkingSecurity.get(state).getTabToken();
        } else {
            sourceUser = state.getUserName();
            sourceToken = state.getToken();
        }
        Connector conn = state.getInstance().getConnector(sourceUser, sourceToken);
        boolean canGive = WalkingSecurity.get(state).canGrantTable(CredentialHelper.create((String)sourceUser, (AuthenticationToken)sourceToken, (String)state.getInstance().getInstanceID()), target, WalkingSecurity.get(state).getTableName());
        if (!"take".equals(action) && !"give".equals(action)) {
            try {
                boolean res = state.getConnector().securityOperations().hasTablePermission(target, tableName, tabPerm);
                if (hasPerm != res) {
                    throw new AccumuloException("Test framework and accumulo are out of sync for user " + conn.whoami() + " for perm " + tabPerm.name() + " with local vs. accumulo being " + hasPerm + " " + res);
                }
                action = hasPerm ? "take" : "give";
            }
            catch (AccumuloSecurityException ae) {
                switch (ae.getSecurityErrorCode()) {
                    case USER_DOESNT_EXIST: {
                        if (exists) {
                            throw new AccumuloException("Framework and Accumulo are out of sync, we think user exists", (Throwable)ae);
                        }
                        return;
                    }
                    case TABLE_DOESNT_EXIST: {
                        if (tabExists) {
                            throw new AccumuloException(conn.whoami(), (Throwable)ae);
                        }
                        return;
                    }
                }
                throw ae;
            }
        }
        boolean trans = WalkingSecurity.get(state).userPassTransient(conn.whoami());
        if ("take".equals(action)) {
            try {
                conn.securityOperations().revokeTablePermission(target, tableName, tabPerm);
            }
            catch (AccumuloSecurityException ae) {
                switch (ae.getSecurityErrorCode()) {
                    case GRANT_INVALID: {
                        throw new AccumuloException("Got a grant invalid on non-System.GRANT option", (Throwable)ae);
                    }
                    case PERMISSION_DENIED: {
                        if (canGive) {
                            throw new AccumuloException(conn.whoami() + " failed to revoke permission to " + target + " when it should have worked", (Throwable)ae);
                        }
                        return;
                    }
                    case USER_DOESNT_EXIST: {
                        if (exists) {
                            throw new AccumuloException("Table user doesn't exist and they SHOULD.", (Throwable)ae);
                        }
                        return;
                    }
                    case TABLE_DOESNT_EXIST: {
                        if (tableExists) {
                            throw new AccumuloException("Table doesn't exist but it should", (Throwable)ae);
                        }
                        return;
                    }
                    case BAD_CREDENTIALS: {
                        if (!trans) {
                            throw new AccumuloException("Bad credentials for user " + conn.whoami());
                        }
                        return;
                    }
                }
                throw new AccumuloException("Got unexpected exception", (Throwable)ae);
            }
            WalkingSecurity.get(state).revokeTablePermission(target, tableName, tabPerm);
        } else if ("give".equals(action)) {
            try {
                conn.securityOperations().grantTablePermission(target, tableName, tabPerm);
            }
            catch (AccumuloSecurityException ae) {
                switch (ae.getSecurityErrorCode()) {
                    case GRANT_INVALID: {
                        throw new AccumuloException("Got a grant invalid on non-System.GRANT option", (Throwable)ae);
                    }
                    case PERMISSION_DENIED: {
                        if (canGive) {
                            throw new AccumuloException(conn.whoami() + " failed to give permission to " + target + " when it should have worked", (Throwable)ae);
                        }
                        return;
                    }
                    case USER_DOESNT_EXIST: {
                        if (exists) {
                            throw new AccumuloException("Table user doesn't exist and they SHOULD.", (Throwable)ae);
                        }
                        return;
                    }
                    case TABLE_DOESNT_EXIST: {
                        if (tableExists) {
                            throw new AccumuloException("Table doesn't exist but it should", (Throwable)ae);
                        }
                        return;
                    }
                    case BAD_CREDENTIALS: {
                        if (!trans) {
                            throw new AccumuloException("Bad credentials for user " + conn.whoami());
                        }
                        return;
                    }
                }
                throw new AccumuloException("Got unexpected exception", (Throwable)ae);
            }
            WalkingSecurity.get(state).grantTablePermission(target, tableName, tabPerm);
        }
        if (!exists) {
            throw new AccumuloException("User shouldn't have existed, but apparantly does");
        }
        if (!tableExists) {
            throw new AccumuloException("Table shouldn't have existed, but apparantly does");
        }
        if (!canGive) {
            throw new AccumuloException(conn.whoami() + " shouldn't have been able to grant privilege");
        }
    }
}

