/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.security;

import java.net.InetAddress;
import java.util.Properties;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.security.WalkingSecurity;

public class AlterTable
extends Test {
    @Override
    public void visit(State state, Properties props) throws Exception {
        Connector conn = state.getInstance().getConnector(WalkingSecurity.get(state).getSysUserName(), WalkingSecurity.get(state).getSysToken());
        String tableName = WalkingSecurity.get(state).getTableName();
        boolean exists = WalkingSecurity.get(state).getTableExists();
        boolean hasPermission = WalkingSecurity.get(state).canAlterTable(WalkingSecurity.get(state).getSysCredentials(), tableName);
        String newTableName = String.format("security_%s_%s_%d", InetAddress.getLocalHost().getHostName().replaceAll("[-.]", "_"), state.getPid(), System.currentTimeMillis());
        AlterTable.renameTable(conn, state, tableName, newTableName, hasPermission, exists);
    }

    public static void renameTable(Connector conn, State state, String oldName, String newName, boolean hasPermission, boolean tableExists) throws AccumuloSecurityException, AccumuloException, TableExistsException {
        try {
            conn.tableOperations().rename(oldName, newName);
        }
        catch (AccumuloSecurityException ae) {
            if (ae.getSecurityErrorCode().equals((Object)SecurityErrorCode.PERMISSION_DENIED)) {
                if (hasPermission) {
                    throw new AccumuloException("Got a security exception when I should have had permission.", (Throwable)ae);
                }
                return;
            }
            if (ae.getSecurityErrorCode().equals((Object)SecurityErrorCode.BAD_CREDENTIALS) && WalkingSecurity.get(state).userPassTransient(conn.whoami())) {
                return;
            }
            throw new AccumuloException("Got unexpected ae error code", (Throwable)ae);
        }
        catch (TableNotFoundException tnfe) {
            if (tableExists) {
                throw new TableExistsException(null, oldName, "Got a TableNotFoundException but it should exist", (Throwable)tnfe);
            }
            return;
        }
        WalkingSecurity.get(state).setTableName(newName);
        if (!hasPermission) {
            throw new AccumuloException("Didn't get Security Exception when we should have");
        }
    }
}

