/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.multitable;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.hadoop.io.Text;

public class Write
extends Test {
    @Override
    public void visit(State state, Properties props) throws Exception {
        ArrayList tables = (ArrayList)state.get("tableList");
        if (tables.isEmpty()) {
            this.log.debug((Object)"No tables to ingest into");
            return;
        }
        Random rand = new Random();
        String tableName = (String)tables.get(rand.nextInt(tables.size()));
        BatchWriter bw = null;
        try {
            bw = state.getMultiTableBatchWriter().getBatchWriter(tableName);
        }
        catch (TableOfflineException e) {
            this.log.error((Object)("Table " + tableName + " is offline!"));
            return;
        }
        catch (TableNotFoundException e) {
            this.log.error((Object)("Table " + tableName + " not found!"));
            return;
        }
        Text meta = new Text("meta");
        String uuid = UUID.randomUUID().toString();
        Mutation m = new Mutation(new Text(uuid));
        int numBytes = rand.nextInt(12000) + 4000;
        byte[] payloadBytes = new byte[numBytes];
        rand.nextBytes(payloadBytes);
        m.put(meta, new Text("payload"), new Value(payloadBytes));
        m.put(meta, new Text("size"), new Value(String.format("%d", numBytes).getBytes(Constants.UTF8)));
        MessageDigest alg = MessageDigest.getInstance("SHA-1");
        alg.update(payloadBytes);
        m.put(meta, new Text("sha1"), new Value(alg.digest()));
        bw.addMutation(m);
        state.set("numWrites", state.getLong("numWrites") + 1L);
    }
}

