/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.multitable;

import java.net.InetAddress;
import java.util.ArrayList;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.test.randomwalk.Fixture;
import org.apache.accumulo.test.randomwalk.State;

public class MultiTableFixture
extends Fixture {
    @Override
    public void setUp(State state) throws Exception {
        String hostname = InetAddress.getLocalHost().getHostName().replaceAll("[-.]", "_");
        state.set("tableNamePrefix", String.format("multi_%s_%s_%d", hostname, state.getPid(), System.currentTimeMillis()));
        state.set("nextId", 0);
        state.set("numWrites", 0L);
        state.set("totalWrites", 0L);
        state.set("tableList", new ArrayList());
    }

    @Override
    public void tearDown(State state) throws Exception {
        if (state.isMultiTableBatchWriterInitialized()) {
            MultiTableBatchWriter mtbw = state.getMultiTableBatchWriter();
            try {
                mtbw.close();
            }
            catch (MutationsRejectedException e) {
                this.log.error((Object)"Ignoring mutations that weren't flushed", (Throwable)e);
            }
            state.resetMultiTableBatchWriter();
        }
        Connector conn = state.getConnector();
        ArrayList tables = (ArrayList)state.get("tableList");
        for (String tableName : tables) {
            try {
                conn.tableOperations().delete(tableName);
                this.log.debug((Object)("Dropping table " + tableName));
            }
            catch (TableNotFoundException e) {
                this.log.warn((Object)("Tried to drop table " + tableName + " but could not be found!"));
            }
        }
    }
}

