/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.multitable;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;

public class CreateTable
extends Test {
    @Override
    public void visit(State state, Properties props) throws Exception {
        Connector conn = state.getConnector();
        int nextId = (Integer)state.get("nextId");
        String tableName = String.format("%s_%d", state.getString("tableNamePrefix"), nextId);
        try {
            conn.tableOperations().create(tableName);
            String tableId = (String)Tables.getNameToIdMap((Instance)state.getInstance()).get(tableName);
            this.log.debug((Object)("created " + tableName + " (id:" + tableId + ")"));
            ArrayList tables = (ArrayList)state.get("tableList");
            tables.add(tableName);
        }
        catch (TableExistsException e) {
            this.log.warn((Object)("Failed to create " + tableName + " as it already exists"));
        }
        state.set("nextId", ++nextId);
    }
}

