/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.multitable;

import java.io.IOException;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Tool;
import org.apache.log4j.Logger;

public class CopyTool
extends Configured
implements Tool {
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

    public int run(String[] args) throws Exception {
        Job job = new Job(this.getConf(), ((Object)((Object)this)).getClass().getSimpleName());
        job.setJarByClass(((Object)((Object)this)).getClass());
        if (job.getJar() == null) {
            this.log.error((Object)"M/R requires a jar file!  Run mvn package.");
            return 1;
        }
        job.setInputFormatClass(AccumuloInputFormat.class);
        AccumuloInputFormat.setConnectorInfo((Job)job, (String)args[0], (AuthenticationToken)new PasswordToken((CharSequence)args[1]));
        AccumuloInputFormat.setInputTableName((Job)job, (String)args[2]);
        AccumuloInputFormat.setScanAuthorizations((Job)job, (Authorizations)Constants.NO_AUTHS);
        AccumuloInputFormat.setZooKeeperInstance((Job)job, (String)args[3], (String)args[4]);
        job.setMapperClass(SeqMapClass.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Mutation.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(AccumuloOutputFormat.class);
        AccumuloOutputFormat.setConnectorInfo((Job)job, (String)args[0], (AuthenticationToken)new PasswordToken((CharSequence)args[1]));
        AccumuloOutputFormat.setCreateTables((Job)job, (boolean)true);
        AccumuloOutputFormat.setDefaultTableName((Job)job, (String)args[5]);
        AccumuloOutputFormat.setZooKeeperInstance((Job)job, (String)args[3], (String)args[4]);
        job.waitForCompletion(true);
        return job.isSuccessful() ? 0 : 1;
    }

    public static class SeqMapClass
    extends Mapper<Key, Value, Text, Mutation> {
        public void map(Key key, Value val, Mapper.Context output) throws IOException, InterruptedException {
            Mutation m = new Mutation(key.getRow());
            m.put(key.getColumnFamily(), key.getColumnQualifier(), val);
            output.write(null, (Object)m);
        }
    }
}

