/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.multitable;

import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.multitable.CopyTool;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class CopyTable
extends Test {
    @Override
    public void visit(State state, Properties props) throws Exception {
        ArrayList tables = (ArrayList)state.get("tableList");
        if (tables.isEmpty()) {
            return;
        }
        Random rand = new Random();
        String srcTableName = (String)tables.remove(rand.nextInt(tables.size()));
        int nextId = (Integer)state.get("nextId");
        String dstTableName = String.format("%s_%d", state.getString("tableNamePrefix"), nextId);
        String[] args = new String[]{"-libjars", state.getMapReduceJars(), state.getProperty("USERNAME"), state.getProperty("PASSWORD"), srcTableName, state.getInstance().getInstanceName(), state.getProperty("ZOOKEEPERS"), dstTableName};
        this.log.debug((Object)("copying " + srcTableName + " to " + dstTableName));
        state.getConnector().tableOperations().create(dstTableName);
        if (ToolRunner.run((Configuration)CachedConfiguration.getInstance(), (Tool)new CopyTool(), (String[])args) != 0) {
            this.log.error((Object)"Failed to run map/red verify");
            return;
        }
        String tableId = (String)Tables.getNameToIdMap((Instance)state.getInstance()).get(dstTableName);
        this.log.debug((Object)("copied " + srcTableName + " to " + dstTableName + " (id - " + tableId + " )"));
        tables.add(dstTableName);
        state.getConnector().tableOperations().delete(srcTableName);
        this.log.debug((Object)("dropped " + srcTableName));
        state.set("nextId", ++nextId);
    }
}

