/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.image;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.image.ImageFixture;
import org.apache.hadoop.io.Text;

public class TableOp
extends Test {
    @Override
    public void visit(State state, Properties props) throws Exception {
        Random rand = new Random();
        String tableName = rand.nextInt(10) < 8 ? state.getString("imageTableName") : state.getString("indexTableName");
        Connector conn = state.getConnector();
        TableOperations tableOps = conn.tableOperations();
        if (!tableOps.exists(tableName)) {
            this.log.error((Object)("Table " + tableName + " does not exist!"));
            return;
        }
        int num = rand.nextInt(10);
        if (num > 6) {
            this.log.debug((Object)("Retrieving info for " + tableName));
            tableOps.getLocalityGroups(tableName);
            tableOps.getProperties(tableName);
            tableOps.listSplits(tableName);
            tableOps.list();
        } else {
            this.log.debug((Object)("Clearing locator cache for " + tableName));
            tableOps.clearLocatorCache(tableName);
        }
        if (rand.nextInt(10) < 3) {
            Map<String, Set<Text>> groups = tableOps.getLocalityGroups(state.getString("imageTableName"));
            if (groups.size() == 0) {
                this.log.debug((Object)("Adding locality groups to " + state.getString("imageTableName")));
                groups = ImageFixture.getLocalityGroups();
            } else {
                this.log.debug((Object)("Removing locality groups from " + state.getString("imageTableName")));
                groups = new HashMap<String, Set<Text>>();
            }
            tableOps.setLocalityGroups(state.getString("imageTableName"), groups);
        }
    }
}

