/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.image;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.image.Write;
import org.apache.hadoop.io.Text;

public class ScanMeta
extends Test {
    @Override
    public void visit(State state, Properties props) throws Exception {
        String indexTableName = state.getString("indexTableName");
        String imageTableName = state.getString("imageTableName");
        String uuid = UUID.randomUUID().toString();
        Connector conn = state.getConnector();
        Scanner imageScanner = conn.createScanner(imageTableName, new Authorizations());
        imageScanner.setRange(new Range(new Text(uuid), null));
        imageScanner.fetchColumn(Write.META_COLUMN_FAMILY, Write.SHA1_COLUMN_QUALIFIER);
        int minScan = Integer.parseInt(props.getProperty("minScan"));
        int maxScan = Integer.parseInt(props.getProperty("maxScan"));
        Random rand = new Random();
        HashMap<Text, Text> hashes = new HashMap<Text, Text>();
        Iterator iter = imageScanner.iterator();
        for (int numToScan = rand.nextInt(maxScan - minScan) + minScan; iter.hasNext() && numToScan > 0; --numToScan) {
            Map.Entry entry = (Map.Entry)iter.next();
            hashes.put(new Text(((Value)entry.getValue()).get()), ((Key)entry.getKey()).getRow());
        }
        this.log.debug((Object)("Found " + hashes.size() + " hashes starting at " + uuid));
        BatchScanner indexScanner = conn.createBatchScanner(indexTableName, Constants.NO_AUTHS, 3);
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (Text row : hashes.keySet()) {
            ranges.add(new Range(row));
        }
        indexScanner.setRanges(ranges);
        HashMap<Text, Text> hashes2 = new HashMap<Text, Text>();
        for (Map.Entry entry : indexScanner) {
            hashes2.put(((Key)entry.getKey()).getRow(), new Text(((Value)entry.getValue()).get()));
        }
        this.log.debug((Object)("Looked up " + ranges.size() + " ranges, found " + hashes2.size()));
        if (!((Object)hashes).equals(hashes2)) {
            this.log.error((Object)("uuids from doc table : " + hashes.values()));
            this.log.error((Object)("uuids from index     : " + hashes2.values()));
            throw new Exception("Mismatch between document table and index " + indexTableName + " " + imageTableName);
        }
        indexScanner.close();
    }
}

