/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.concurrent;

import java.util.Properties;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.MasterClient;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.MasterGoalState;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.master.state.SetGoalState;
import org.apache.accumulo.server.security.SecurityConstants;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.trace.instrument.Tracer;

public class StartAll
extends Test {
    @Override
    public void visit(State state, Properties props) throws Exception {
        this.log.info((Object)"Starting all servers");
        SetGoalState.main((String[])new String[]{MasterGoalState.NORMAL.name()});
        Process exec = Runtime.getRuntime().exec(new String[]{System.getenv().get("ACCUMULO_HOME") + "/bin/start-all.sh"});
        exec.waitFor();
        while (true) {
            try {
                MasterMonitorInfo masterStats;
                do {
                    MasterClientService.Client client = MasterClient.getConnection((Instance)HdfsZooInstance.getInstance());
                    masterStats = client.getMasterStats(Tracer.traceInfo(), SecurityConstants.getSystemCredentials());
                } while (masterStats.tServerInfo.isEmpty());
            }
            catch (Exception ex) {
                UtilWaitThread.sleep((long)1000L);
                continue;
            }
            break;
        }
    }
}

