/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.concurrent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.hadoop.io.Text;

public class DeleteRange
extends Test {
    @Override
    public void visit(State state, Properties props) throws Exception {
        Connector conn = state.getConnector();
        Random rand = (Random)state.get("rand");
        List tableNames = (List)state.get("tables");
        String tableName = (String)tableNames.get(rand.nextInt(tableNames.size()));
        ArrayList<Text> range = new ArrayList<Text>();
        do {
            range.add(new Text(String.format("%016x", rand.nextLong() & Long.MAX_VALUE)));
            range.add(new Text(String.format("%016x", rand.nextLong() & Long.MAX_VALUE)));
        } while (((Text)range.get(0)).equals(range.get(1)));
        Collections.sort(range);
        if (rand.nextInt(20) == 0) {
            range.set(0, null);
        }
        if (rand.nextInt(20) == 0) {
            range.set(1, null);
        }
        try {
            conn.tableOperations().deleteRows(tableName, (Text)range.get(0), (Text)range.get(1));
            this.log.debug((Object)("deleted rows (" + range.get(0) + " -> " + range.get(1) + "] in " + tableName));
        }
        catch (TableNotFoundException tne) {
            this.log.debug((Object)("deleted rows " + tableName + " failed, doesnt exist"));
        }
        catch (TableOfflineException toe) {
            this.log.debug((Object)("deleted rows " + tableName + " failed, offline"));
        }
    }
}

