/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.concurrent;

import java.util.Properties;
import java.util.SortedSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.commons.math.random.RandomData;
import org.apache.commons.math.random.RandomDataImpl;

public class Config
extends Test {
    private static final String LAST_SETTING = "lastSetting";
    private static final String LAST_TABLE_SETTING = "lastTableSetting";
    Setting[] settings = new Setting[]{Config.s(Property.TSERV_BLOOM_LOAD_MAXCONCURRENT, 1L, 10L), Config.s(Property.TSERV_BULK_PROCESS_THREADS, 1L, 10L), Config.s(Property.TSERV_BULK_RETRY, 1L, 10L), Config.s(Property.TSERV_BULK_TIMEOUT, 10L, 600L), Config.s(Property.TSERV_BULK_ASSIGNMENT_THREADS, 1L, 10L), Config.s(Property.TSERV_DATACACHE_SIZE, 0L, 1000000000L), Config.s(Property.TSERV_INDEXCACHE_SIZE, 0L, 1000000000L), Config.s(Property.TSERV_CLIENT_TIMEOUT, 100L, 10000L), Config.s(Property.TSERV_MAJC_MAXCONCURRENT, 1L, 10L), Config.s(Property.TSERV_MAJC_DELAY, 100L, 10000L), Config.s(Property.TSERV_MAJC_THREAD_MAXOPEN, 3L, 100L), Config.s(Property.TSERV_MINC_MAXCONCURRENT, 1L, 10L), Config.s(Property.TSERV_DEFAULT_BLOCKSIZE, 100000L, 10000000L), Config.s(Property.TSERV_MAX_IDLE, 10000L, 500000L), Config.s(Property.TSERV_MAXMEM, 1000000L, 0xC0000000L), Config.s(Property.TSERV_READ_AHEAD_MAXCONCURRENT, 1L, 25L), Config.s(Property.TSERV_MIGRATE_MAXCONCURRENT, 1L, 10L), Config.s(Property.TSERV_MUTATION_QUEUE_MAX, 10000L, 0x100000L), Config.s(Property.TSERV_RECOVERY_MAX_CONCURRENT, 1L, 100L), Config.s(Property.TSERV_SCAN_MAX_OPENFILES, 10L, 1000L), Config.s(Property.TSERV_THREADCHECK, 100L, 10000L), Config.s(Property.TSERV_MINTHREADS, 1L, 100L), Config.s(Property.TSERV_SESSION_MAXIDLE, 100L, 300000L), Config.s(Property.TSERV_SORT_BUFFER_SIZE, 0x100000L, 0x40000000L), Config.s(Property.TSERV_TABLET_SPLIT_FINDMIDPOINT_MAXOPEN, 5L, 100L), Config.s(Property.TSERV_WAL_BLOCKSIZE, 0x100000L, 0x280000000L), Config.s(Property.TSERV_WORKQ_THREADS, 1L, 10L), Config.s(Property.MASTER_BULK_THREADPOOL_SIZE, 1L, 10L), Config.s(Property.MASTER_BULK_RETRIES, 1L, 10L), Config.s(Property.MASTER_BULK_TIMEOUT, 10L, 600L), Config.s(Property.MASTER_FATE_THREADPOOL_SIZE, 1L, 100L), Config.s(Property.MASTER_RECOVERY_DELAY, 0L, 100L), Config.s(Property.MASTER_LEASE_RECOVERY_WAITING_PERIOD, 0L, 10L), Config.s(Property.MASTER_RECOVERY_MAXTIME, 10L, 1000L), Config.s(Property.MASTER_THREADCHECK, 100L, 10000L), Config.s(Property.MASTER_MINTHREADS, 1L, 200L)};
    Setting[] tableSettings = new Setting[]{Config.s(Property.TABLE_MAJC_RATIO, 1L, 10L), Config.s(Property.TABLE_MAJC_COMPACTALL_IDLETIME, 100L, 36000000L), Config.s(Property.TABLE_SPLIT_THRESHOLD, 10240L, 0x280000000L), Config.s(Property.TABLE_MINC_COMPACT_IDLETIME, 100L, 360000000L), Config.s(Property.TABLE_SCAN_MAXMEM, 10240L, 0xA00000L), Config.s(Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE, 10240L, 0xA00000L), Config.s(Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE_INDEX, 10240L, 0xA00000L), Config.s(Property.TABLE_FILE_REPLICATION, 0L, 5L), Config.s(Property.TABLE_FILE_MAX, 2L, 50L)};

    static Setting s(Property property, long min, long max) {
        return new Setting(property, min, max);
    }

    @Override
    public void visit(State state, Properties props) throws Exception {
        Object lastSetting = state.getMap().get(LAST_SETTING);
        if (lastSetting != null) {
            int choice = Integer.parseInt(lastSetting.toString());
            Property property = this.settings[choice].property;
            this.log.debug((Object)("Setting " + property.getKey() + " back to " + property.getDefaultValue()));
            state.getConnector().instanceOperations().setProperty(property.getKey(), property.getDefaultValue());
        }
        if ((lastSetting = state.getMap().get(LAST_TABLE_SETTING)) != null) {
            String[] parts = lastSetting.toString().split(",");
            String table = parts[0];
            int choice = Integer.parseInt(parts[1]);
            Property property = this.tableSettings[choice].property;
            if (state.getConnector().tableOperations().exists(table)) {
                this.log.debug((Object)("Setting " + property.getKey() + " on " + table + " back to " + property.getDefaultValue()));
                try {
                    state.getConnector().tableOperations().setProperty(table, property.getKey(), property.getDefaultValue());
                }
                catch (AccumuloException ex) {
                    if (ex.getCause() instanceof ThriftTableOperationException) {
                        ThriftTableOperationException ttoe = (ThriftTableOperationException)ex.getCause();
                        if (ttoe.type == TableOperationExceptionType.NOTFOUND) {
                            return;
                        }
                    }
                    throw ex;
                }
            }
        }
        state.getMap().remove(LAST_SETTING);
        state.getMap().remove(LAST_TABLE_SETTING);
        RandomDataImpl random = new RandomDataImpl();
        if (random.nextInt(0, 1) == 0) {
            this.changeTableSetting((RandomData)random, state, props);
        } else {
            this.changeSetting((RandomData)random, state, props);
        }
    }

    private void changeTableSetting(RandomData random, State state, Properties props) throws Exception {
        int choice = random.nextInt(0, this.tableSettings.length - 1);
        Setting setting = this.tableSettings[choice];
        SortedSet<String> tables = state.getConnector().tableOperations().list().tailSet("ctt").headSet("ctu");
        if (tables.isEmpty()) {
            return;
        }
        String table = random.nextSample(tables, 1)[0].toString();
        long newValue = random.nextLong(setting.min, setting.max);
        state.getMap().put(LAST_TABLE_SETTING, table + "," + choice);
        this.log.debug((Object)("Setting " + setting.property.getKey() + " on table " + table + " to " + newValue));
        try {
            state.getConnector().tableOperations().setProperty(table, setting.property.getKey(), "" + newValue);
        }
        catch (AccumuloException ex) {
            if (ex.getCause() instanceof ThriftTableOperationException) {
                ThriftTableOperationException ttoe = (ThriftTableOperationException)ex.getCause();
                if (ttoe.type == TableOperationExceptionType.NOTFOUND) {
                    return;
                }
            }
            throw ex;
        }
    }

    private void changeSetting(RandomData random, State state, Properties props) throws Exception {
        int choice = random.nextInt(0, this.settings.length - 1);
        Setting setting = this.settings[choice];
        long newValue = random.nextLong(setting.min, setting.max);
        state.getMap().put(LAST_SETTING, "" + choice);
        this.log.debug((Object)("Setting " + setting.property.getKey() + " to " + newValue));
        state.getConnector().instanceOperations().setProperty(setting.property.getKey(), "" + newValue);
    }

    static class Setting {
        public Property property;
        public long min;
        public long max;

        public Setting(Property property, long min, long max) {
            this.property = property;
            this.min = min;
            this.max = max;
        }
    }
}

