/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.concurrent;

import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.concurrent.ConcurrentFixture;
import org.apache.hadoop.io.Text;

public class Compact
extends Test {
    @Override
    public void visit(State state, Properties props) throws Exception {
        Connector conn = state.getConnector();
        Random rand = (Random)state.get("rand");
        List tableNames = (List)state.get("tables");
        String tableName = (String)tableNames.get(rand.nextInt(tableNames.size()));
        List<Text> range = ConcurrentFixture.generateRange(rand);
        try {
            boolean wait = rand.nextBoolean();
            conn.tableOperations().compact(tableName, range.get(0), range.get(1), false, wait);
            this.log.debug((Object)((wait ? "compacted " : "initiated compaction ") + tableName + " from " + range.get(0) + " to " + range.get(1)));
        }
        catch (TableNotFoundException tne) {
            this.log.debug((Object)("compact " + tableName + " from " + range.get(0) + " to " + range.get(1) + " failed, doesnt exist"));
        }
        catch (TableOfflineException toe) {
            this.log.debug((Object)("compact " + tableName + " from " + range.get(0) + " to " + range.get(1) + " failed, offline"));
        }
    }
}

