/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.concurrent;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;

public class CloneTable
extends Test {
    @Override
    public void visit(State state, Properties props) throws Exception {
        Connector conn = state.getConnector();
        Random rand = (Random)state.get("rand");
        List tableNames = (List)state.get("tables");
        String srcTableName = (String)tableNames.get(rand.nextInt(tableNames.size()));
        String newTableName = (String)tableNames.get(rand.nextInt(tableNames.size()));
        boolean flush = rand.nextBoolean();
        try {
            this.log.debug((Object)("Cloning table " + srcTableName + " " + newTableName + " " + flush));
            conn.tableOperations().clone(srcTableName, newTableName, flush, new HashMap(), new HashSet());
        }
        catch (TableExistsException e) {
            this.log.debug((Object)("Clone " + srcTableName + " failed, " + newTableName + " exist"));
        }
        catch (TableNotFoundException e) {
            this.log.debug((Object)("Clone " + srcTableName + " failed, doesnt exist"));
        }
    }
}

