/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.concurrent;

import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;

public class CheckPermission
extends Test {
    @Override
    public void visit(State state, Properties props) throws Exception {
        Connector conn = state.getConnector();
        Random rand = (Random)state.get("rand");
        List userNames = (List)state.get("users");
        String userName = (String)userNames.get(rand.nextInt(userNames.size()));
        List tableNames = (List)state.get("tables");
        String tableName = (String)tableNames.get(rand.nextInt(tableNames.size()));
        try {
            if (rand.nextBoolean()) {
                this.log.debug((Object)("Checking systerm permission " + userName));
                conn.securityOperations().hasSystemPermission(userName, SystemPermission.values()[rand.nextInt(SystemPermission.values().length)]);
            } else {
                this.log.debug((Object)("Checking table permission " + userName + " " + tableName));
                conn.securityOperations().hasTablePermission(userName, tableName, TablePermission.values()[rand.nextInt(TablePermission.values().length)]);
            }
        }
        catch (AccumuloSecurityException ex) {
            this.log.debug((Object)("Unable to check permissions: " + ex.getCause()));
        }
    }
}

