/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.concurrent;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;

public class CheckBalance
extends Test {
    static final String LAST_UNBALANCED_TIME = "lastUnbalancedTime";
    static final String UNBALANCED_COUNT = "unbalancedCount";

    @Override
    public void visit(State state, Properties props) throws Exception {
        this.log.debug((Object)"checking balance");
        HashMap<String, Long> counts = new HashMap<String, Long>();
        Scanner scanner = state.getConnector().createScanner("!METADATA", Constants.NO_AUTHS);
        scanner.fetchColumnFamily(Constants.METADATA_CURRENT_LOCATION_COLUMN_FAMILY);
        for (Map.Entry entry : scanner) {
            String location = ((Key)entry.getKey()).getColumnQualifier().toString();
            Long count = (Long)counts.get(location);
            if (count == null) {
                count = 0L;
            }
            counts.put(location, count + 1L);
        }
        double total = 0.0;
        for (Long count : counts.values()) {
            total += (double)count.longValue();
        }
        double average = total / (double)counts.size();
        double maxDifference = Math.max(1.0, average / 5.0);
        String unbalancedLocation = null;
        long lastCount = 0L;
        boolean balanced = true;
        for (Map.Entry entry : counts.entrySet()) {
            long thisCount = (Long)entry.getValue();
            if (!(Math.abs((double)thisCount - average) > maxDifference)) continue;
            balanced = false;
            this.log.debug((Object)("unbalanced: " + (String)entry.getKey() + " has " + entry.getValue() + " tablets and the average is " + average));
            unbalancedLocation = (String)entry.getKey();
            lastCount = thisCount;
        }
        if (!balanced) {
            Long last = state.getLong(LAST_UNBALANCED_TIME);
            if (last != null && System.currentTimeMillis() - last > 900000L) {
                Integer count = state.getInteger(UNBALANCED_COUNT);
                if (count == null) {
                    count = 0;
                }
                if (count > 3) {
                    throw new Exception("servers are unbalanced! location " + unbalancedLocation + " count " + lastCount + " too far from average " + average);
                }
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
                state.set(UNBALANCED_COUNT, count);
            }
            if (last == null) {
                state.set(LAST_UNBALANCED_TIME, System.currentTimeMillis());
            }
        } else {
            state.remove(LAST_UNBALANCED_TIME);
            state.remove(UNBALANCED_COUNT);
        }
    }
}

