/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.concurrent;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;

public class ChangePermissions
extends Test {
    @Override
    public void visit(State state, Properties props) throws Exception {
        Connector conn = state.getConnector();
        Random rand = (Random)state.get("rand");
        List userNames = (List)state.get("users");
        String userName = (String)userNames.get(rand.nextInt(userNames.size()));
        List tableNames = (List)state.get("tables");
        String tableName = (String)tableNames.get(rand.nextInt(tableNames.size()));
        try {
            if (rand.nextBoolean()) {
                this.changeSystemPermission(conn, rand, userName);
            } else {
                this.changeTablePermission(conn, rand, userName, tableName);
            }
        }
        catch (AccumuloSecurityException ex) {
            this.log.debug((Object)("Unable to change user permissions: " + ex.getCause()));
        }
    }

    private void changeTablePermission(Connector conn, Random rand, String userName, String tableName) throws AccumuloException, AccumuloSecurityException {
        EnumSet<TablePermission> perms = EnumSet.noneOf(TablePermission.class);
        for (TablePermission p : TablePermission.values()) {
            if (!conn.securityOperations().hasTablePermission(userName, tableName, p)) continue;
            perms.add(p);
        }
        EnumSet<TablePermission> more = EnumSet.allOf(TablePermission.class);
        more.removeAll(perms);
        if (rand.nextBoolean() && more.size() > 0) {
            ArrayList<TablePermission> moreList = new ArrayList<TablePermission>(more);
            TablePermission choice = (TablePermission)moreList.get(rand.nextInt(moreList.size()));
            this.log.debug((Object)("adding permission " + choice));
            conn.securityOperations().grantTablePermission(userName, tableName, choice);
        } else if (perms.size() > 0) {
            ArrayList<TablePermission> permList = new ArrayList<TablePermission>(perms);
            TablePermission choice = (TablePermission)permList.get(rand.nextInt(permList.size()));
            this.log.debug((Object)("removing permission " + choice));
            conn.securityOperations().revokeTablePermission(userName, tableName, choice);
        }
    }

    private void changeSystemPermission(Connector conn, Random rand, String userName) throws AccumuloException, AccumuloSecurityException {
        EnumSet<SystemPermission> perms = EnumSet.noneOf(SystemPermission.class);
        for (SystemPermission p : SystemPermission.values()) {
            if (!conn.securityOperations().hasSystemPermission(userName, p)) continue;
            perms.add(p);
        }
        EnumSet<SystemPermission> more = EnumSet.allOf(SystemPermission.class);
        more.removeAll(perms);
        more.remove(SystemPermission.GRANT);
        if (rand.nextBoolean() && more.size() > 0) {
            ArrayList<SystemPermission> moreList = new ArrayList<SystemPermission>(more);
            SystemPermission choice = (SystemPermission)moreList.get(rand.nextInt(moreList.size()));
            this.log.debug((Object)("adding permission " + choice));
            conn.securityOperations().grantSystemPermission(userName, choice);
        } else if (perms.size() > 0) {
            ArrayList<SystemPermission> permList = new ArrayList<SystemPermission>(perms);
            SystemPermission choice = (SystemPermission)permList.get(rand.nextInt(permList.size()));
            this.log.debug((Object)("removing permission " + choice));
            conn.securityOperations().revokeSystemPermission(userName, choice);
        }
    }
}

