/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;

public class ChangeAuthorizations
extends Test {
    @Override
    public void visit(State state, Properties props) throws Exception {
        Connector conn = state.getConnector();
        Random rand = (Random)state.get("rand");
        List userNames = (List)state.get("users");
        String userName = (String)userNames.get(rand.nextInt(userNames.size()));
        try {
            ArrayList<byte[]> auths = new ArrayList<byte[]>(conn.securityOperations().getUserAuthorizations(userName).getAuthorizations());
            if (rand.nextBoolean()) {
                String authorization = String.format("a%d", rand.nextInt(5000));
                this.log.debug((Object)("adding authorization " + authorization));
                auths.add(authorization.getBytes(Constants.UTF8));
            } else if (auths.size() > 0) {
                this.log.debug((Object)("removing authorization " + new String((byte[])auths.remove(0), Constants.UTF8)));
            }
            conn.securityOperations().changeUserAuthorizations(userName, new Authorizations(auths));
        }
        catch (AccumuloSecurityException ex) {
            this.log.debug((Object)("Unable to change user authorizations: " + ex.getCause()));
        }
    }
}

