/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.concurrent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableDeletedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;

public class BatchScan
extends Test {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(State state, Properties props) throws Exception {
        Connector conn = state.getConnector();
        Random rand = (Random)state.get("rand");
        List tableNames = (List)state.get("tables");
        String tableName = (String)tableNames.get(rand.nextInt(tableNames.size()));
        try {
            BatchScanner bs = conn.createBatchScanner(tableName, Constants.NO_AUTHS, 3);
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int i = 0; i < rand.nextInt(2000) + 1; ++i) {
                ranges.add(new Range((CharSequence)String.format("%016x", rand.nextLong() & Long.MAX_VALUE)));
            }
            bs.setRanges(ranges);
            try {
                Iterator iter = bs.iterator();
                while (iter.hasNext()) {
                    iter.next();
                }
            }
            finally {
                bs.close();
            }
            this.log.debug((Object)("Wrote to " + tableName));
        }
        catch (TableNotFoundException e) {
            this.log.debug((Object)("BatchScan " + tableName + " failed, doesnt exist"));
        }
        catch (TableDeletedException tde) {
            this.log.debug((Object)("BatchScan " + tableName + " failed, table deleted"));
        }
        catch (TableOfflineException e) {
            this.log.debug((Object)("BatchScan " + tableName + " failed, offline"));
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof AccumuloSecurityException) {
                this.log.debug((Object)("BatchScan " + tableName + " failed, permission error"));
            }
            throw e;
        }
    }
}

