/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.bulk;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.cli.ClientOnRequiredTable;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.bulk.BulkPlusOne;
import org.apache.accumulo.test.randomwalk.bulk.Setup;
import org.apache.hadoop.io.Text;

public class Verify
extends Test {
    static byte[] zero = new byte[]{48};

    @Override
    public void visit(State state, Properties props) throws Exception {
        ThreadPoolExecutor threadPool = Setup.getThreadPool(state);
        threadPool.shutdown();
        int lastSize = 0;
        while (!threadPool.isTerminated()) {
            int size = threadPool.getQueue().size() + threadPool.getActiveCount();
            this.log.info((Object)("Waiting for " + size + " nodes to complete"));
            if (size != lastSize) {
                this.makingProgress();
            }
            lastSize = size;
            threadPool.awaitTermination(10L, TimeUnit.SECONDS);
        }
        if (!"true".equals(state.get("bulkImportSuccess"))) {
            this.log.info((Object)"Not verifying bulk import test due to import failures");
            return;
        }
        String user = state.getConnector().whoami();
        Authorizations auths = state.getConnector().securityOperations().getUserAuthorizations(user);
        Scanner scanner = state.getConnector().createScanner(Setup.getTableName(), auths);
        scanner.fetchColumnFamily(BulkPlusOne.CHECK_COLUMN_FAMILY);
        for (Map.Entry entry : scanner) {
            byte[] value = ((Value)entry.getValue()).get();
            if (Arrays.equals(value, zero)) continue;
            throw new Exception("Bad key at " + entry);
        }
        scanner.clearColumns();
        scanner.fetchColumnFamily(BulkPlusOne.MARKER_CF);
        RowIterator rowIter = new RowIterator((Iterable)scanner);
        while (rowIter.hasNext()) {
            Iterator row = rowIter.next();
            long prev = 0L;
            Text rowText = null;
            while (row.hasNext()) {
                long curr;
                Map.Entry entry = (Map.Entry)row.next();
                if (rowText == null) {
                    rowText = ((Key)entry.getKey()).getRow();
                }
                if ((curr = Long.valueOf(((Key)entry.getKey()).getColumnQualifier().toString()).longValue()) - 1L != prev) {
                    throw new Exception("Bad marker count " + entry.getKey() + " " + entry.getValue() + " " + prev);
                }
                if (!((Value)entry.getValue()).toString().equals("1")) {
                    throw new Exception("Bad marker value " + entry.getKey() + " " + entry.getValue());
                }
                prev = curr;
            }
            if (BulkPlusOne.counter.get() == prev) continue;
            throw new Exception("Row " + rowText + " does not have all markers " + BulkPlusOne.counter.get() + " " + prev);
        }
        this.log.info((Object)("Test successful on table " + Setup.getTableName()));
        state.getConnector().tableOperations().delete(Setup.getTableName());
    }

    public static void main(String[] args) throws Exception {
        ClientOnRequiredTable opts = new ClientOnRequiredTable();
        opts.parseArgs(Verify.class.getName(), args, new Object[0]);
        Scanner scanner = opts.getConnector().createScanner(opts.tableName, opts.auths);
        scanner.fetchColumnFamily(BulkPlusOne.CHECK_COLUMN_FAMILY);
        Text startBadRow = null;
        Text lastBadRow = null;
        Value currentBadValue = null;
        for (Map.Entry entry : scanner) {
            byte[] value = ((Value)entry.getValue()).get();
            if (!Arrays.equals(value, zero)) {
                if (currentBadValue == null || ((Value)entry.getValue()).equals(currentBadValue)) {
                    lastBadRow = new Text(((Key)entry.getKey()).getRow());
                    if (startBadRow == null) {
                        startBadRow = lastBadRow;
                    }
                } else {
                    Verify.report(startBadRow, lastBadRow, currentBadValue);
                    startBadRow = lastBadRow = new Text(((Key)entry.getKey()).getRow());
                }
                currentBadValue = new Value((Value)entry.getValue());
                continue;
            }
            if (startBadRow != null) {
                Verify.report(startBadRow, lastBadRow, currentBadValue);
            }
            lastBadRow = null;
            startBadRow = null;
            currentBadValue = null;
        }
        if (startBadRow != null) {
            Verify.report(startBadRow, lastBadRow, currentBadValue);
        }
    }

    private static void report(Text startBadRow, Text lastBadRow, Value value) {
        System.out.println("Bad value " + new String(value.get(), Constants.UTF8));
        System.out.println(" Range [" + startBadRow + " -> " + lastBadRow + "]");
    }
}

