/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.bulk;

import java.util.Map;
import java.util.Random;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.bulk.BulkPlusOne;
import org.apache.accumulo.test.randomwalk.bulk.BulkTest;
import org.apache.accumulo.test.randomwalk.bulk.Merge;
import org.apache.accumulo.test.randomwalk.bulk.Setup;
import org.apache.hadoop.io.Text;

public class ConsistencyCheck
extends BulkTest {
    @Override
    protected void runLater(State state) throws Exception {
        Random rand = (Random)state.get("rand");
        Text row = Merge.getRandomRow(rand);
        this.log.info((Object)("Checking " + row));
        String user = state.getConnector().whoami();
        Authorizations auths = state.getConnector().securityOperations().getUserAuthorizations(user);
        Scanner scanner = state.getConnector().createScanner(Setup.getTableName(), auths);
        scanner = new IsolatedScanner(scanner);
        scanner.setRange(new Range(row));
        scanner.fetchColumnFamily(BulkPlusOne.CHECK_COLUMN_FAMILY);
        Value v = null;
        Key first = null;
        for (Map.Entry entry : scanner) {
            if (v == null) {
                v = (Value)entry.getValue();
                first = (Key)entry.getKey();
            }
            if (v.equals(entry.getValue())) continue;
            throw new RuntimeException("Inconsistent value at " + entry.getKey() + " was " + entry.getValue() + " should be " + v + " first read at " + first);
        }
    }
}

