/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.security.CredentialHelper;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.log4j.Logger;

public class State {
    private static final Logger log = Logger.getLogger(State.class);
    private HashMap<String, Object> stateMap = new HashMap();
    private Properties props;
    private int numVisits = 0;
    private int maxVisits = Integer.MAX_VALUE;
    private MultiTableBatchWriter mtbw = null;
    private Connector connector = null;
    private Instance instance = null;

    State(Properties props) {
        this.props = props;
    }

    public void setMaxVisits(int num) {
        this.maxVisits = num;
    }

    public void visitedNode() throws Exception {
        ++this.numVisits;
        if (this.numVisits > this.maxVisits) {
            log.debug((Object)("Visited max number (" + this.maxVisits + ") of nodes"));
            throw new Exception("Visited max number (" + this.maxVisits + ") of nodes");
        }
    }

    public String getPid() {
        return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    }

    public void set(String key, Object value) {
        this.stateMap.put(key, value);
    }

    public void remove(String key) {
        this.stateMap.remove(key);
    }

    public Object get(String key) {
        if (!this.stateMap.containsKey(key)) {
            throw new RuntimeException("State does not contain " + key);
        }
        return this.stateMap.get(key);
    }

    public HashMap<String, Object> getMap() {
        return this.stateMap;
    }

    public Properties getProperties() {
        return new Properties(this.props);
    }

    public String getString(String key) {
        return (String)this.stateMap.get(key);
    }

    public Integer getInteger(String key) {
        return (Integer)this.stateMap.get(key);
    }

    public Long getLong(String key) {
        return (Long)this.stateMap.get(key);
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public Connector getConnector() throws AccumuloException, AccumuloSecurityException {
        if (this.connector == null) {
            this.connector = this.getInstance().getConnector(this.getUserName(), this.getToken());
        }
        return this.connector;
    }

    public TCredentials getCredentials() {
        String username = this.getUserName();
        AuthenticationToken password = this.getToken();
        return CredentialHelper.createSquelchError((String)username, (AuthenticationToken)password, (String)this.getInstance().getInstanceID());
    }

    public String getUserName() {
        return this.props.getProperty("USERNAME");
    }

    public AuthenticationToken getToken() {
        return new PasswordToken((CharSequence)this.props.getProperty("PASSWORD"));
    }

    public Instance getInstance() {
        if (this.instance == null) {
            String instance = this.props.getProperty("INSTANCE");
            String zookeepers = this.props.getProperty("ZOOKEEPERS");
            this.instance = new ZooKeeperInstance(instance, zookeepers);
        }
        return this.instance;
    }

    public MultiTableBatchWriter getMultiTableBatchWriter() {
        if (this.mtbw == null) {
            long maxMem = Long.parseLong(this.props.getProperty("MAX_MEM"));
            long maxLatency = Long.parseLong(this.props.getProperty("MAX_LATENCY"));
            int numThreads = Integer.parseInt(this.props.getProperty("NUM_THREADS"));
            this.mtbw = this.connector.createMultiTableBatchWriter(new BatchWriterConfig().setMaxMemory(maxMem).setMaxLatency(maxLatency, TimeUnit.MILLISECONDS).setMaxWriteThreads(numThreads));
        }
        return this.mtbw;
    }

    public boolean isMultiTableBatchWriterInitialized() {
        return this.mtbw != null;
    }

    public void resetMultiTableBatchWriter() {
        if (!this.mtbw.isClosed()) {
            log.warn((Object)"Setting non-closed MultiTableBatchWriter to null (leaking resources)");
        }
        this.mtbw = null;
    }

    public String getMapReduceJars() {
        String acuHome = System.getenv("ACCUMULO_HOME");
        String zkHome = System.getenv("ZOOKEEPER_HOME");
        if (acuHome == null || zkHome == null) {
            throw new RuntimeException("ACCUMULO or ZOOKEEPER home not set!");
        }
        String retval = null;
        File zkLib = new File(zkHome);
        String[] files = zkLib.list();
        for (int i = 0; i < files.length; ++i) {
            String f = files[i];
            if (!f.matches("^zookeeper-.+jar$")) continue;
            retval = retval == null ? String.format("%s/%s", zkLib.getAbsolutePath(), f) : retval + String.format(",%s/%s", zkLib.getAbsolutePath(), f);
        }
        File libdir = new File(acuHome + "/lib");
        for (String jar : "accumulo-core accumulo-server accumulo-fate accumulo-trace libthrift".split(" ")) {
            retval = retval + String.format(",%s/%s.jar", libdir.getAbsolutePath(), jar);
        }
        return retval;
    }
}

