/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.test.randomwalk.Fixture;
import org.apache.accumulo.test.randomwalk.Framework;
import org.apache.accumulo.test.randomwalk.Node;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Module
extends Node {
    private HashMap<String, Node> nodes = new HashMap();
    private HashMap<String, Properties> localProps = new HashMap();
    private HashMap<String, String> prefixes = new HashMap();
    private HashMap<String, AdjList> adjMap = new HashMap();
    private HashMap<String, Set<String>> aliasMap = new HashMap();
    private final File xmlFile;
    private String initNodeId;
    private Fixture fixture = null;
    Thread timer = null;
    final int time = 300000;
    AtomicBoolean runningLong = new AtomicBoolean(false);
    long systemTime;

    public Module(File xmlFile) throws Exception {
        this.xmlFile = xmlFile;
        this.loadFromXml();
    }

    @Override
    public void visit(State state, Properties props) throws Exception {
        Properties initProps = this.getProps("_init");
        initProps.putAll((Map<?, ?>)props);
        String prop = initProps.getProperty("maxHops");
        int maxHops = prop == null || prop.equals("0") || prop.equals("") ? Integer.MAX_VALUE : Integer.parseInt(initProps.getProperty("maxHops", "0"));
        prop = initProps.getProperty("maxSec");
        int maxSec = prop == null || prop.equals("0") || prop.equals("") ? Integer.MAX_VALUE : Integer.parseInt(initProps.getProperty("maxSec", "0"));
        prop = initProps.getProperty("teardown");
        boolean teardown = prop == null || prop.equals("true") || prop.equals("");
        if (this.fixture != null) {
            this.fixture.setUp(state);
        }
        Node initNode = this.getNode(this.initNodeId);
        boolean test = false;
        if (initNode instanceof Test) {
            this.startTimer(initNode);
            test = true;
        }
        initNode.visit(state, this.getProps(this.initNodeId));
        if (test) {
            this.stopTimer(initNode);
        }
        state.visitedNode();
        Set<String> aliases = this.aliasMap.get(this.initNodeId);
        if (aliases != null) {
            for (String alias : aliases) {
                ((Alias)this.nodes.get(alias)).update(this.initNodeId);
            }
        }
        String curNodeId = this.initNodeId;
        int numHops = 0;
        long startTime = System.currentTimeMillis() / 1000L;
        while (true) {
            if (curNodeId.equalsIgnoreCase("END")) {
                this.log.debug((Object)"reached END state");
                break;
            }
            long curTime = System.currentTimeMillis() / 1000L;
            if (curTime - startTime > (long)maxSec) {
                this.log.debug((Object)("reached maxSec(" + maxSec + ")"));
                break;
            }
            if (numHops > maxHops) {
                this.log.debug((Object)("reached maxHops(" + maxHops + ")"));
                break;
            }
            ++numHops;
            if (!this.adjMap.containsKey(curNodeId) && !curNodeId.startsWith("alias.")) {
                throw new Exception("Reached node(" + curNodeId + ") without outgoing edges in module(" + this + ")");
            }
            AdjList adj = this.adjMap.get(curNodeId);
            String nextNodeId = adj.randomNeighbor();
            Node nextNode = this.getNode(nextNodeId);
            if (nextNode instanceof Alias) {
                nextNodeId = ((Alias)nextNode).getTargetId();
                nextNode = ((Alias)nextNode).get();
            }
            Properties nodeProps = this.getProps(nextNodeId);
            try {
                test = false;
                if (nextNode instanceof Test) {
                    this.startTimer(nextNode);
                    test = true;
                }
                nextNode.visit(state, nodeProps);
                if (test) {
                    this.stopTimer(nextNode);
                }
            }
            catch (Exception e) {
                this.log.debug((Object)("Connector belongs to user: " + state.getConnector().whoami()));
                this.log.debug((Object)("Exception occured at: " + System.currentTimeMillis()));
                this.log.debug((Object)("Properties for node: " + nextNodeId));
                for (Map.Entry<Object, Object> entry : nodeProps.entrySet()) {
                    this.log.debug((Object)("  " + entry.getKey() + ": " + entry.getValue()));
                }
                this.log.debug((Object)"Overall Properties");
                for (Map.Entry<Object, Object> entry : state.getProperties().entrySet()) {
                    this.log.debug((Object)("  " + entry.getKey() + ": " + entry.getValue()));
                }
                this.log.debug((Object)"State information");
                for (String key : new TreeSet<String>(state.getMap().keySet())) {
                    Object value = state.getMap().get(key);
                    String logMsg = "  " + key + ": ";
                    logMsg = value == null ? logMsg + "null" : (value instanceof String || value instanceof Map || value instanceof Collection || value instanceof Number ? logMsg + value : (value instanceof byte[] ? logMsg + new String((byte[])value, Constants.UTF8) : (value instanceof PasswordToken ? logMsg + new String(((PasswordToken)value).getPassword(), Constants.UTF8) : logMsg + value.getClass() + " - " + value)));
                    this.log.debug((Object)logMsg);
                }
                throw new Exception("Error running node " + nextNodeId, e);
            }
            state.visitedNode();
            aliases = this.aliasMap.get(curNodeId);
            if (aliases != null) {
                for (String alias : aliases) {
                    ((Alias)this.nodes.get(alias)).update(curNodeId);
                }
            }
            curNodeId = nextNodeId;
        }
        if (teardown && this.fixture != null) {
            this.log.debug((Object)"tearing down module");
            this.fixture.tearDown(state);
        }
    }

    private void startTimer(final Node initNode) {
        this.runningLong.set(false);
        this.timer = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Module.this.systemTime = System.currentTimeMillis();
                    Thread.sleep(300000L);
                }
                catch (InterruptedException ie) {
                    return;
                }
                long timeSinceLastProgress = System.currentTimeMillis() - initNode.lastProgress();
                if (timeSinceLastProgress > 300000L) {
                    Module.this.log.warn((Object)("Node " + initNode + " has been running for " + (double)timeSinceLastProgress / 1000.0 + " seconds. You may want to look into it."));
                    Module.this.runningLong.set(true);
                }
            }
        });
        initNode.makingProgress();
        this.timer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopTimer(Node nextNode) {
        Thread thread = this.timer;
        synchronized (thread) {
            this.timer.interrupt();
            try {
                this.timer.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.runningLong.get()) {
            this.log.warn((Object)("Node " + nextNode + ", which was running long, has now completed after " + (double)(System.currentTimeMillis() - this.systemTime) / 1000.0 + " seconds"));
        }
    }

    @Override
    public String toString() {
        return this.xmlFile.toString();
    }

    private String getFullName(String name) {
        int index = name.indexOf(".");
        if (index == -1 || name.endsWith(".xml")) {
            return name;
        }
        String id = name.substring(0, index);
        if (!this.prefixes.containsKey(id)) {
            this.log.warn((Object)("Id (" + id + ") was not found in prefixes"));
            return name;
        }
        return this.prefixes.get(id).concat(name.substring(index + 1));
    }

    private Node createNode(String id, String src) throws Exception {
        if (id.equalsIgnoreCase("END") || id.startsWith("dummy")) {
            if (!this.nodes.containsKey(id)) {
                this.nodes.put(id, new Dummy(id));
            }
            return this.nodes.get(id);
        }
        if (id.startsWith("alias")) {
            if (!this.nodes.containsKey(id)) {
                this.nodes.put(id, new Alias(id));
            }
            return this.nodes.get(id);
        }
        Node node = src == null || src.isEmpty() ? Framework.getInstance().getNode(this.getFullName(id)) : Framework.getInstance().getNode(this.getFullName(src));
        this.nodes.put(id, node);
        return node;
    }

    private Node getNode(String id) throws Exception {
        if (this.nodes.containsKey(id)) {
            return this.nodes.get(id);
        }
        if (id.equalsIgnoreCase("END")) {
            this.nodes.put(id, new Dummy(id));
            return this.nodes.get(id);
        }
        return Framework.getInstance().getNode(this.getFullName(id));
    }

    private Properties getProps(String nodeId) {
        if (this.localProps.containsKey(nodeId)) {
            return this.localProps.get(nodeId);
        }
        return new Properties();
    }

    private void loadFromXml() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document d = null;
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema moduleSchema = sf.newSchema(this.getClass().getClassLoader().getResource("randomwalk/module.xsd"));
        dbf.setSchema(moduleSchema);
        try {
            DocumentBuilder docbuilder = dbf.newDocumentBuilder();
            d = docbuilder.parse(this.xmlFile);
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to parse: " + this.xmlFile), (Throwable)e);
            throw new Exception("Failed to parse: " + this.xmlFile);
        }
        NodeList nodelist = d.getDocumentElement().getElementsByTagName("package");
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Element el = (Element)nodelist.item(i);
            String value = el.getAttribute("value");
            if (!value.endsWith(".")) {
                value = value.concat(".");
            }
            this.prefixes.put(el.getAttribute("prefix"), value);
        }
        nodelist = d.getDocumentElement().getElementsByTagName("fixture");
        if (nodelist.getLength() > 0) {
            Element fixtureEl = (Element)nodelist.item(0);
            this.fixture = (Fixture)Class.forName(this.getFullName(fixtureEl.getAttribute("id"))).newInstance();
        }
        Element initEl = (Element)d.getDocumentElement().getElementsByTagName("init").item(0);
        this.initNodeId = initEl.getAttribute("id");
        Properties initProps = new Properties();
        String attr = initEl.getAttribute("maxHops");
        if (attr != null) {
            initProps.setProperty("maxHops", attr);
        }
        if ((attr = initEl.getAttribute("maxSec")) != null) {
            initProps.setProperty("maxSec", attr);
        }
        if ((attr = initEl.getAttribute("teardown")) != null) {
            initProps.setProperty("teardown", attr);
        }
        this.localProps.put("_init", initProps);
        nodelist = d.getDocumentElement().getElementsByTagName("node");
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Element nodeEl = (Element)nodelist.item(i);
            String id = nodeEl.getAttribute("id");
            if (this.adjMap.containsKey(id)) {
                throw new Exception("Module already contains: " + id);
            }
            String src = nodeEl.getAttribute("src");
            this.createNode(id, src);
            Properties props = new Properties();
            props.setProperty("maxHops", nodeEl.getAttribute("maxHops"));
            props.setProperty("maxSec", nodeEl.getAttribute("maxSec"));
            props.setProperty("teardown", nodeEl.getAttribute("teardown"));
            NodeList aliaslist = nodeEl.getElementsByTagName("alias");
            TreeSet<String> aliases = new TreeSet<String>();
            for (int j = 0; j < aliaslist.getLength(); ++j) {
                Element propEl = (Element)aliaslist.item(j);
                if (!propEl.hasAttribute("name")) {
                    throw new Exception("Node " + id + " has alias with no identifying name");
                }
                String key = "alias." + propEl.getAttribute("name");
                aliases.add(key);
                this.createNode(key, null);
            }
            if (aliases.size() > 0) {
                this.aliasMap.put(id, aliases);
            }
            NodeList proplist = nodeEl.getElementsByTagName("property");
            for (int j = 0; j < proplist.getLength(); ++j) {
                Element propEl = (Element)proplist.item(j);
                if (!propEl.hasAttribute("key") || !propEl.hasAttribute("value")) {
                    throw new Exception("Node " + id + " has property with no key or value");
                }
                String key = propEl.getAttribute("key");
                if (key.equals("maxHops") || key.equals("maxSec") || key.equals("teardown")) {
                    throw new Exception("The following property can only be set in attributes: " + key);
                }
                props.setProperty(key, propEl.getAttribute("value"));
            }
            this.localProps.put(id, props);
            AdjList edges = new AdjList();
            this.adjMap.put(id, edges);
            NodeList edgelist = nodeEl.getElementsByTagName("edge");
            if (edgelist.getLength() == 0) {
                throw new Exception("Node " + id + " has no edges!");
            }
            for (int j = 0; j < edgelist.getLength(); ++j) {
                Element edgeEl = (Element)edgelist.item(j);
                String edgeID = edgeEl.getAttribute("id");
                if (!edgeEl.hasAttribute("weight")) {
                    throw new Exception("Edge with id=" + edgeID + " is missing weight");
                }
                int weight = Integer.parseInt(edgeEl.getAttribute("weight"));
                edges.addEdge(edgeID, weight);
            }
        }
    }

    private class AdjList {
        private List<Edge> edges = new ArrayList<Edge>();
        private int totalWeight = 0;
        private Random rand = new Random();

        private AdjList() {
        }

        private void addEdge(String nodeId, int weight) {
            this.totalWeight += weight;
            Edge e = new Edge();
            e.nodeId = nodeId;
            e.weight = weight;
            this.edges.add(e);
        }

        private String randomNeighbor() throws Exception {
            String nodeId = null;
            this.rand = new Random();
            int randNum = this.rand.nextInt(this.totalWeight) + 1;
            int sum = 0;
            for (Edge e : this.edges) {
                nodeId = e.nodeId;
                if (randNum > (sum += e.weight)) continue;
                break;
            }
            return nodeId;
        }
    }

    private class Edge {
        String nodeId;
        int weight;

        private Edge() {
        }
    }

    private class Alias
    extends Node {
        Node target = null;
        String targetId;
        String id;

        Alias(String id) {
            this.id = id;
        }

        @Override
        public void visit(State state, Properties props) throws Exception {
            throw new Exception("You don't visit aliases!");
        }

        @Override
        public String toString() {
            return this.id;
        }

        public void update(String node) throws Exception {
            this.targetId = node;
            this.target = Module.this.getNode(node);
        }

        public Node get() {
            return this.target;
        }

        public String getTargetId() {
            return this.targetId;
        }
    }

    private class Dummy
    extends Node {
        String name;

        Dummy(String name) {
            this.name = name;
        }

        @Override
        public void visit(State state, Properties props) {
            String print = props.getProperty("print");
            if (print != null) {
                Level level = Level.toLevel((String)print);
                this.log.log((Priority)level, (Object)this.name);
            }
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

