/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.performance.thrift;

import com.beust.jcommander.Parameter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.thrift.InitialMultiScan;
import org.apache.accumulo.core.data.thrift.InitialScan;
import org.apache.accumulo.core.data.thrift.IterInfo;
import org.apache.accumulo.core.data.thrift.MapFileInfo;
import org.apache.accumulo.core.data.thrift.MultiScanResult;
import org.apache.accumulo.core.data.thrift.ScanResult;
import org.apache.accumulo.core.data.thrift.TColumn;
import org.apache.accumulo.core.data.thrift.TKeyExtent;
import org.apache.accumulo.core.data.thrift.TMutation;
import org.apache.accumulo.core.data.thrift.TRange;
import org.apache.accumulo.core.data.thrift.UpdateErrors;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.tabletserver.thrift.ActiveCompaction;
import org.apache.accumulo.core.tabletserver.thrift.ActiveScan;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.tabletserver.thrift.TabletStats;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.server.client.ClientServiceHandler;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.master.state.Assignment;
import org.apache.accumulo.server.master.state.MetaDataStateStore;
import org.apache.accumulo.server.master.state.MetaDataTableScanner;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.server.security.SecurityConstants;
import org.apache.accumulo.server.util.TServerUtils;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.accumulo.trace.thrift.TInfo;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;

public class NullTserver {
    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(NullTserver.class.getName(), args, new Object[0]);
        TransactionWatcher watcher = new TransactionWatcher();
        ThriftClientHandler tch = new ThriftClientHandler(HdfsZooInstance.getInstance(), watcher);
        TabletClientService.Processor processor = new TabletClientService.Processor((TabletClientService.Iface)tch);
        TServerUtils.startTServer((int)opts.port, (TProcessor)processor, (String)"NullTServer", (String)"null tserver", (int)2, (long)1000L, (long)0xA00000L);
        InetSocketAddress addr = new InetSocketAddress(InetAddress.getLocalHost(), opts.port);
        ZooKeeperInstance zki = new ZooKeeperInstance(opts.iname, opts.keepers);
        String tableId = Tables.getTableId((Instance)zki, (String)opts.tableName);
        Range tableRange = new KeyExtent(new Text(tableId), null, null).toMetadataRange();
        MetaDataTableScanner s = new MetaDataTableScanner((Instance)zki, SecurityConstants.getSystemCredentials(), tableRange);
        long randomSessionID = opts.port;
        TServerInstance instance = new TServerInstance(addr, randomSessionID);
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        while (s.hasNext()) {
            TabletLocationState next = s.next();
            assignments.add(new Assignment(next.extent, instance));
        }
        s.close();
        MetaDataStateStore store = new MetaDataStateStore();
        store.setLocations(assignments);
        while (true) {
            UtilWaitThread.sleep((long)10000L);
        }
    }

    static class Opts
    extends Help {
        @Parameter(names={"-i", "--instance"}, description="instance name", required=true)
        String iname = null;
        @Parameter(names={"-z", "--keepers"}, description="comma-separated list of zookeeper host:ports", required=true)
        String keepers = null;
        @Parameter(names={"--table"}, description="table to adopt", required=true)
        String tableName = null;
        @Parameter(names={"--port"}, description="port number to use")
        int port = DefaultConfiguration.getInstance().getPort(Property.TSERV_CLIENTPORT);

        Opts() {
        }
    }

    public static class ThriftClientHandler
    extends ClientServiceHandler
    implements TabletClientService.Iface {
        private long updateSession = 1L;

        public ThriftClientHandler(Instance instance, TransactionWatcher watcher) {
            super(instance, watcher);
        }

        public long startUpdate(TInfo tinfo, TCredentials credentials) {
            return this.updateSession++;
        }

        public void applyUpdates(TInfo tinfo, long updateID, TKeyExtent keyExtent, List<TMutation> mutation) {
        }

        public UpdateErrors closeUpdate(TInfo tinfo, long updateID) {
            return new UpdateErrors(new HashMap(), new ArrayList(), new HashMap());
        }

        public List<TKeyExtent> bulkImport(TInfo tinfo, TCredentials credentials, long tid, Map<TKeyExtent, Map<String, MapFileInfo>> files, boolean setTime) {
            return null;
        }

        public void closeMultiScan(TInfo tinfo, long scanID) {
        }

        public void closeScan(TInfo tinfo, long scanID) {
        }

        public MultiScanResult continueMultiScan(TInfo tinfo, long scanID) {
            return null;
        }

        public ScanResult continueScan(TInfo tinfo, long scanID) {
            return null;
        }

        public void splitTablet(TInfo tinfo, TCredentials credentials, TKeyExtent extent, ByteBuffer splitPoint) {
        }

        public InitialMultiScan startMultiScan(TInfo tinfo, TCredentials credentials, Map<TKeyExtent, List<TRange>> batch, List<TColumn> columns, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, List<ByteBuffer> authorizations, boolean waitForWrites) {
            return null;
        }

        public InitialScan startScan(TInfo tinfo, TCredentials credentials, TKeyExtent extent, TRange range, List<TColumn> columns, int batchSize, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, List<ByteBuffer> authorizations, boolean waitForWrites, boolean isolated) {
            return null;
        }

        public void update(TInfo tinfo, TCredentials credentials, TKeyExtent keyExtent, TMutation mutation) {
        }

        public TabletServerStatus getTabletServerStatus(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
            return null;
        }

        public List<TabletStats> getTabletStats(TInfo tinfo, TCredentials credentials, String tableId) throws ThriftSecurityException, TException {
            return null;
        }

        public TabletStats getHistoricalStats(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
            return null;
        }

        public void halt(TInfo tinfo, TCredentials credentials, String lock) throws ThriftSecurityException, TException {
        }

        public void fastHalt(TInfo tinfo, TCredentials credentials, String lock) {
        }

        public void loadTablet(TInfo tinfo, TCredentials credentials, String lock, TKeyExtent extent) throws TException {
        }

        public void unloadTablet(TInfo tinfo, TCredentials credentials, String lock, TKeyExtent extent, boolean save) throws TException {
        }

        public List<ActiveScan> getActiveScans(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
            return new ArrayList<ActiveScan>();
        }

        public void chop(TInfo tinfo, TCredentials credentials, String lock, TKeyExtent extent) throws TException {
        }

        public void flushTablet(TInfo tinfo, TCredentials credentials, String lock, TKeyExtent extent) throws TException {
        }

        public void compact(TInfo tinfo, TCredentials credentials, String lock, String tableId, ByteBuffer startRow, ByteBuffer endRow) throws TException {
        }

        public void flush(TInfo tinfo, TCredentials credentials, String lock, String tableId, ByteBuffer startRow, ByteBuffer endRow) throws TException {
        }

        public void removeLogs(TInfo tinfo, TCredentials credentials, List<String> filenames) throws TException {
        }

        public List<ActiveCompaction> getActiveCompactions(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
            return new ArrayList<ActiveCompaction>();
        }
    }
}

