/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.performance.scan;

import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.thrift.IterInfo;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.SortedMapIterator;
import org.apache.accumulo.core.iterators.system.ColumnFamilySkippingIterator;
import org.apache.accumulo.core.iterators.system.ColumnQualifierFilter;
import org.apache.accumulo.core.iterators.system.DeletingIterator;
import org.apache.accumulo.core.iterators.system.MultiIterator;
import org.apache.accumulo.core.iterators.system.VisibilityFilter;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.CredentialHelper;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.util.AddressUtil;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.Stat;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.cli.ClientOnRequiredTable;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.util.MetadataTable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class CollectTabletStats {
    private static final Logger log = Logger.getLogger(CollectTabletStats.class);

    public static void main(String[] args) throws Exception {
        Connector conn;
        Test test;
        List files;
        ArrayList<Test> tests;
        int i;
        final CollectOptions opts = new CollectOptions();
        final ScannerOpts scanOpts = new ScannerOpts();
        opts.parseArgs(CollectTabletStats.class.getName(), args, new Object[]{scanOpts});
        String[] columnsTmp = new String[]{};
        if (opts.columns != null) {
            columnsTmp = opts.columns.split(",");
        }
        final String[] columns = columnsTmp;
        final FileSystem fs = FileSystem.get((Configuration)CachedConfiguration.getInstance());
        Instance instance = opts.getInstance();
        final ServerConfiguration sconf = new ServerConfiguration(instance);
        String tableId = (String)Tables.getNameToIdMap((Instance)instance).get(opts.tableName);
        if (tableId == null) {
            log.error((Object)("Unable to find table named " + opts.tableName));
            System.exit(-1);
        }
        HashMap<KeyExtent, String> locations = new HashMap<KeyExtent, String>();
        List<KeyExtent> candidates = CollectTabletStats.findTablets(!opts.selectFarTablets, CredentialHelper.create((String)opts.principal, (AuthenticationToken)opts.getToken(), (String)opts.instance), opts.tableName, instance, locations);
        if (candidates.size() < opts.numThreads) {
            System.err.println("ERROR : Unable to find " + opts.numThreads + " " + (opts.selectFarTablets ? "far" : "local") + " tablets");
            System.exit(-1);
        }
        List<KeyExtent> tabletsToTest = CollectTabletStats.selectRandomTablets(opts.numThreads, candidates);
        HashMap<KeyExtent, List<String>> tabletFiles = new HashMap<KeyExtent, List<String>>();
        for (KeyExtent ke : tabletsToTest) {
            List<String> files2 = CollectTabletStats.getTabletFiles(CredentialHelper.create((String)opts.principal, (AuthenticationToken)opts.getToken(), (String)opts.instance), opts.getInstance(), tableId, ke);
            tabletFiles.put(ke, files2);
        }
        System.out.println();
        System.out.println("run location      : " + InetAddress.getLocalHost().getHostName() + "/" + InetAddress.getLocalHost().getHostAddress());
        System.out.println("num threads       : " + opts.numThreads);
        System.out.println("table             : " + opts.tableName);
        System.out.println("table id          : " + tableId);
        for (KeyExtent ke : tabletsToTest) {
            System.out.println("\t *** Information about tablet " + ke.getUUID() + " *** ");
            System.out.println("\t\t# files in tablet : " + ((List)tabletFiles.get(ke)).size());
            System.out.println("\t\ttablet location   : " + (String)locations.get(ke));
            CollectTabletStats.reportHdfsBlockLocations((List)tabletFiles.get(ke));
        }
        System.out.println("%n*** RUNNING TEST ***%n");
        ExecutorService threadPool = Executors.newFixedThreadPool(opts.numThreads);
        for (i = 0; i < opts.iterations; ++i) {
            tests = new ArrayList<Test>();
            for (final KeyExtent ke : tabletsToTest) {
                files = (List)tabletFiles.get(ke);
                test = new Test(ke){

                    @Override
                    public int runTest() throws Exception {
                        return CollectTabletStats.readFiles(fs, sconf.getConfiguration(), files, ke, columns);
                    }
                };
                tests.add(test);
            }
            CollectTabletStats.runTest("read files", tests, opts.numThreads, threadPool);
        }
        for (i = 0; i < opts.iterations; ++i) {
            tests = new ArrayList();
            for (final KeyExtent ke : tabletsToTest) {
                files = (List)tabletFiles.get(ke);
                test = new Test(ke){

                    @Override
                    public int runTest() throws Exception {
                        return CollectTabletStats.readFilesUsingIterStack(fs, sconf, files, opts.auths, ke, columns, false);
                    }
                };
                tests.add(test);
            }
            CollectTabletStats.runTest("read tablet files w/ system iter stack", tests, opts.numThreads, threadPool);
        }
        for (i = 0; i < opts.iterations; ++i) {
            tests = new ArrayList();
            for (final KeyExtent ke : tabletsToTest) {
                files = (List)tabletFiles.get(ke);
                test = new Test(ke){

                    @Override
                    public int runTest() throws Exception {
                        return CollectTabletStats.readFilesUsingIterStack(fs, sconf, files, opts.auths, ke, columns, true);
                    }
                };
                tests.add(test);
            }
            CollectTabletStats.runTest("read tablet files w/ table iter stack", tests, opts.numThreads, threadPool);
        }
        for (i = 0; i < opts.iterations; ++i) {
            tests = new ArrayList();
            conn = opts.getConnector();
            for (final KeyExtent ke : tabletsToTest) {
                test = new Test(ke){

                    @Override
                    public int runTest() throws Exception {
                        return CollectTabletStats.scanTablet(conn, opts.tableName, opts.auths, scanOpts.scanBatchSize, ke.getPrevEndRow(), ke.getEndRow(), columns);
                    }
                };
                tests.add(test);
            }
            CollectTabletStats.runTest("read tablet data through accumulo", tests, opts.numThreads, threadPool);
        }
        for (final KeyExtent ke : tabletsToTest) {
            conn = opts.getConnector();
            threadPool.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        CollectTabletStats.calcTabletStats(conn, opts.tableName, opts.auths, scanOpts.scanBatchSize, ke, columns);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        threadPool.shutdown();
    }

    private static void runTest(String desc, List<Test> tests, int numThreads, ExecutorService threadPool) throws Exception {
        System.out.println("\tRunning test : " + desc);
        CountDownLatch startSignal = new CountDownLatch(1);
        CountDownLatch finishedSignal = new CountDownLatch(numThreads);
        for (Test test : tests) {
            threadPool.submit(test);
            test.setSignals(startSignal, finishedSignal);
        }
        startSignal.countDown();
        finishedSignal.await();
        long minTime = Long.MAX_VALUE;
        long maxTime = Long.MIN_VALUE;
        long count = 0L;
        for (Test test : tests) {
            minTime = Math.min(test.getStartTime(), minTime);
            maxTime = Math.max(test.getFinishTime(), maxTime);
            count += (long)test.getCount();
        }
        double time = (double)(maxTime - minTime) / 1000.0;
        System.out.printf("\tAggregate stats  count: %,d cells  time: %6.2f  rate: %,6.2f cells/sec%n", count, time, (double)count / time);
        System.out.println();
        System.gc();
        System.gc();
        System.gc();
    }

    private static List<KeyExtent> findTablets(boolean selectLocalTablets, TCredentials credentials, String table, Instance zki, Map<KeyExtent, String> locations) throws Exception {
        TreeSet tablets = new TreeSet();
        MetadataTable.getEntries((Instance)zki, (TCredentials)credentials, (String)table, (boolean)false, locations, tablets);
        InetAddress localaddress = InetAddress.getLocalHost();
        ArrayList<KeyExtent> candidates = new ArrayList<KeyExtent>();
        for (Map.Entry<KeyExtent, String> entry : locations.entrySet()) {
            boolean isLocal = AddressUtil.parseAddress((String)entry.getValue(), (int)4).getAddress().equals(localaddress);
            if (selectLocalTablets && isLocal) {
                candidates.add(entry.getKey());
                continue;
            }
            if (selectLocalTablets || isLocal) continue;
            candidates.add(entry.getKey());
        }
        return candidates;
    }

    private static List<KeyExtent> selectRandomTablets(int numThreads, List<KeyExtent> candidates) {
        ArrayList<KeyExtent> tabletsToTest = new ArrayList<KeyExtent>();
        Random rand = new Random();
        for (int i = 0; i < numThreads; ++i) {
            int rindex = rand.nextInt(candidates.size());
            tabletsToTest.add(candidates.get(rindex));
            Collections.swap(candidates, rindex, candidates.size() - 1);
            candidates = candidates.subList(0, candidates.size() - 1);
        }
        return tabletsToTest;
    }

    private static List<String> getTabletFiles(TCredentials token, Instance zki, String tableId, KeyExtent ke) {
        ArrayList<String> files = new ArrayList<String>();
        for (String cq : MetadataTable.getDataFileSizes((KeyExtent)ke, (TCredentials)token).keySet()) {
            files.add(ServerConstants.getTablesDir() + "/" + tableId + cq);
        }
        return files;
    }

    private static void reportHdfsBlockLocations(List<String> files) throws Exception {
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        System.out.println("\t\tFile block report : ");
        for (String file : files) {
            FileStatus status = fs.getFileStatus(new Path(file));
            if (status.isDir()) {
                status = fs.getFileStatus(new Path(file + "/data"));
            }
            BlockLocation[] locs = fs.getFileBlockLocations(status, 0L, status.getLen());
            System.out.println("\t\t\tBlocks for : " + file);
            for (BlockLocation blockLocation : locs) {
                System.out.printf("\t\t\t\t offset : %,13d  hosts :", blockLocation.getOffset());
                for (String host : blockLocation.getHosts()) {
                    System.out.print(" " + host);
                }
                System.out.println();
            }
        }
        System.out.println();
    }

    private static SortedKeyValueIterator<Key, Value> createScanIterator(KeyExtent ke, Collection<SortedKeyValueIterator<Key, Value>> mapfiles, Authorizations authorizations, byte[] defaultLabels, HashSet<Column> columnSet, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, boolean useTableIterators, TableConfiguration conf) throws IOException {
        SortedMapIterator smi = new SortedMapIterator(new TreeMap());
        ArrayList<Object> iters = new ArrayList<Object>(mapfiles.size() + 1);
        iters.addAll(mapfiles);
        iters.add(smi);
        MultiIterator multiIter = new MultiIterator(iters, ke);
        DeletingIterator delIter = new DeletingIterator((SortedKeyValueIterator)multiIter, false);
        ColumnFamilySkippingIterator cfsi = new ColumnFamilySkippingIterator((SortedKeyValueIterator)delIter);
        ColumnQualifierFilter colFilter = new ColumnQualifierFilter((SortedKeyValueIterator)cfsi, columnSet);
        VisibilityFilter visFilter = new VisibilityFilter((SortedKeyValueIterator)colFilter, authorizations, defaultLabels);
        if (useTableIterators) {
            return IteratorUtil.loadIterators((IteratorUtil.IteratorScope)IteratorUtil.IteratorScope.scan, (SortedKeyValueIterator)visFilter, (KeyExtent)ke, (AccumuloConfiguration)conf, ssiList, ssio, null);
        }
        return visFilter;
    }

    private static int readFiles(FileSystem fs, AccumuloConfiguration aconf, List<String> files, KeyExtent ke, String[] columns) throws Exception {
        int count = 0;
        HashSet<ByteSequence> columnSet = CollectTabletStats.createColumnBSS(columns);
        for (String file : files) {
            FileSKVIterator reader = FileOperations.getInstance().openReader(file, false, fs, fs.getConf(), aconf);
            Range range = new Range(ke.getPrevEndRow(), false, ke.getEndRow(), true);
            reader.seek(range, columnSet, columnSet.size() != 0);
            while (reader.hasTop() && !range.afterEndKey((Key)reader.getTopKey())) {
                ++count;
                reader.next();
            }
            reader.close();
        }
        return count;
    }

    private static HashSet<ByteSequence> createColumnBSS(String[] columns) {
        HashSet<ByteSequence> columnSet = new HashSet<ByteSequence>();
        for (String c : columns) {
            columnSet.add((ByteSequence)new ArrayByteSequence(c));
        }
        return columnSet;
    }

    private static int readFilesUsingIterStack(FileSystem fs, ServerConfiguration aconf, List<String> files, Authorizations auths, KeyExtent ke, String[] columns, boolean useTableIterators) throws Exception {
        ArrayList<SortedKeyValueIterator<Key, Value>> readers = new ArrayList<SortedKeyValueIterator<Key, Value>>(files.size());
        for (String file : files) {
            readers.add((SortedKeyValueIterator<Key, Value>)FileOperations.getInstance().openReader(file, false, fs, fs.getConf(), aconf.getConfiguration()));
        }
        List<IterInfo> emptyIterinfo = Collections.emptyList();
        Map<String, Map<String, String>> emptySsio = Collections.emptyMap();
        TableConfiguration tconf = aconf.getTableConfiguration(ke.getTableId().toString());
        SortedKeyValueIterator<Key, Value> reader = CollectTabletStats.createScanIterator(ke, readers, auths, new byte[0], new HashSet<Column>(), emptyIterinfo, emptySsio, useTableIterators, tconf);
        HashSet<ByteSequence> columnSet = CollectTabletStats.createColumnBSS(columns);
        reader.seek(new Range(ke.getPrevEndRow(), false, ke.getEndRow(), true), columnSet, columnSet.size() != 0);
        int count = 0;
        while (reader.hasTop()) {
            ++count;
            reader.next();
        }
        return count;
    }

    private static int scanTablet(Connector conn, String table, Authorizations auths, int batchSize, Text prevEndRow, Text endRow, String[] columns) throws Exception {
        Scanner scanner = conn.createScanner(table, auths);
        scanner.setBatchSize(batchSize);
        scanner.setRange(new Range(prevEndRow, false, endRow, true));
        for (String c : columns) {
            scanner.fetchColumnFamily(new Text(c));
        }
        int count = 0;
        for (Map.Entry entry : scanner) {
            if (entry == null) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void calcTabletStats(Connector conn, String table, Authorizations auths, int batchSize, KeyExtent ke, String[] columns) throws Exception {
        Scanner scanner = conn.createScanner(table, auths);
        scanner.setBatchSize(batchSize);
        scanner.setRange(new Range(ke.getPrevEndRow(), false, ke.getEndRow(), true));
        for (String c : columns) {
            scanner.fetchColumnFamily(new Text(c));
        }
        Stat rowLen = new Stat();
        Stat cfLen = new Stat();
        Stat cqLen = new Stat();
        Stat cvLen = new Stat();
        Stat valLen = new Stat();
        Stat colsPerRow = new Stat();
        Text lastRow = null;
        int colsPerRowCount = 0;
        for (Map.Entry entry : scanner) {
            Key key = (Key)entry.getKey();
            Text row = key.getRow();
            if (lastRow == null) {
                lastRow = row;
            }
            if (!lastRow.equals((Object)row)) {
                colsPerRow.addStat((long)colsPerRowCount);
                lastRow = row;
                colsPerRowCount = 0;
            }
            ++colsPerRowCount;
            rowLen.addStat((long)row.getLength());
            cfLen.addStat((long)key.getColumnFamilyData().length());
            cqLen.addStat((long)key.getColumnQualifierData().length());
            cvLen.addStat((long)key.getColumnVisibilityData().length());
            valLen.addStat((long)((Value)entry.getValue()).get().length);
        }
        PrintStream printStream = System.out;
        synchronized (printStream) {
            System.out.println("");
            System.out.println("\tTablet " + ke.getUUID() + " statistics : ");
            CollectTabletStats.printStat("Row length", rowLen);
            CollectTabletStats.printStat("Column family length", cfLen);
            CollectTabletStats.printStat("Column qualifier length", cqLen);
            CollectTabletStats.printStat("Column visibility length", cvLen);
            CollectTabletStats.printStat("Value length", valLen);
            CollectTabletStats.printStat("Columns per row", colsPerRow);
            System.out.println("");
        }
    }

    private static void printStat(String desc, Stat s) {
        System.out.printf("\t\tDescription: [%30s]  average: %,6.2f  std dev: %,6.2f  min: %,d  max: %,d %n", desc, s.getAverage(), s.getStdDev(), s.getMin(), s.getMax());
    }

    private static abstract class Test
    implements Runnable {
        private int count;
        private long t1;
        private long t2;
        private CountDownLatch startCdl;
        private CountDownLatch finishCdl;
        private KeyExtent ke;

        Test(KeyExtent ke) {
            this.ke = ke;
        }

        public abstract int runTest() throws Exception;

        void setSignals(CountDownLatch scdl, CountDownLatch fcdl) {
            this.startCdl = scdl;
            this.finishCdl = fcdl;
        }

        @Override
        public void run() {
            try {
                this.startCdl.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.t1 = System.currentTimeMillis();
            try {
                this.count = this.runTest();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.t2 = System.currentTimeMillis();
            double time = (double)(this.t2 - this.t1) / 1000.0;
            System.out.printf("\t\ttablet: " + this.ke.getUUID() + "  thread: " + Thread.currentThread().getId() + " count: %,d cells  time: %6.2f  rate: %,6.2f cells/sec%n", this.count, time, (double)this.count / time);
            this.finishCdl.countDown();
        }

        int getCount() {
            return this.count;
        }

        long getStartTime() {
            return this.t1;
        }

        long getFinishTime() {
            return this.t2;
        }
    }

    static class CollectOptions
    extends ClientOnRequiredTable {
        @Parameter(names={"--iterations"}, description="number of iterations")
        int iterations = 3;
        @Parameter(names={"-t"}, description="number of threads")
        int numThreads = 1;
        @Parameter(names={"-f"}, description="select far tablets, default is to use local tablets")
        boolean selectFarTablets = false;
        @Parameter(names={"-c"}, description="comma separated list of columns")
        String columns;

        CollectOptions() {
        }
    }
}

