/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.performance.metadata;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.AddressUtil;
import org.apache.accumulo.core.util.Stat;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.security.SecurityConstants;
import org.apache.hadoop.io.Text;

public class MetadataBatchScanTest {
    public static void main(String[] args) throws Exception {
        Mutation mut;
        BatchWriter bw;
        final Connector connector = new ZooKeeperInstance("acu14", "localhost").getConnector("!SYSTEM", SecurityConstants.getSystemToken());
        TreeSet<Long> splits = new TreeSet<Long>();
        Random r = new Random(42L);
        while (splits.size() < 99999) {
            splits.add((r.nextLong() & Long.MAX_VALUE) % 1000000000000L);
        }
        Text tid = new Text("8");
        Text per = null;
        ArrayList<KeyExtent> extents = new ArrayList<KeyExtent>();
        for (Long split : splits) {
            Text er = new Text(String.format("%012d", split));
            KeyExtent ke = new KeyExtent(tid, er, per);
            per = er;
            extents.add(ke);
        }
        extents.add(new KeyExtent(tid, null, per));
        if (args[0].equals("write")) {
            bw = connector.createBatchWriter("!METADATA", new BatchWriterConfig());
            for (KeyExtent extent : extents) {
                mut = extent.getPrevRowUpdateMutation();
                new TServerInstance(AddressUtil.parseAddress((String)"192.168.1.100", (int)4567), "DEADBEEF").putLocation(mut);
                bw.addMutation(mut);
            }
            bw.close();
        } else if (args[0].equals("writeFiles")) {
            bw = connector.createBatchWriter("!METADATA", new BatchWriterConfig());
            for (KeyExtent extent : extents) {
                mut = new Mutation(extent.getMetadataEntry());
                String dir = "/t-" + UUID.randomUUID();
                Constants.METADATA_DIRECTORY_COLUMN.put(mut, new Value(dir.getBytes(Constants.UTF8)));
                for (int i = 0; i < 5; ++i) {
                    mut.put(Constants.METADATA_DATAFILE_COLUMN_FAMILY, new Text(dir + "/00000_0000" + i + ".map"), new Value("10000,1000000".getBytes(Constants.UTF8)));
                }
                bw.addMutation(mut);
            }
            bw.close();
        } else if (args[0].equals("scan")) {
            int i;
            int numThreads = Integer.parseInt(args[1]);
            final int numLoop = Integer.parseInt(args[2]);
            int numLookups = Integer.parseInt(args[3]);
            HashSet<Integer> indexes = new HashSet<Integer>();
            while (indexes.size() < numLookups) {
                indexes.add(r.nextInt(extents.size()));
            }
            final ArrayList<Range> ranges = new ArrayList<Range>();
            for (Integer i2 : indexes) {
                ranges.add(((KeyExtent)extents.get(i2)).toMetadataRange());
            }
            Thread[] threads = new Thread[numThreads];
            for (int i3 = 0; i3 < threads.length; ++i3) {
                threads[i3] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            System.out.println(MetadataBatchScanTest.runScanTest(connector, numLoop, ranges));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            long t1 = System.currentTimeMillis();
            for (i = 0; i < threads.length; ++i) {
                threads[i].start();
            }
            for (i = 0; i < threads.length; ++i) {
                threads[i].join();
            }
            long t2 = System.currentTimeMillis();
            System.out.printf("tt : %6.2f%n", (double)(t2 - t1) / 1000.0);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private static ScanStats runScanTest(Connector connector, int numLoop, List<Range> ranges) throws Exception {
        Scanner scanner = null;
        BatchScanner bs = connector.createBatchScanner("!METADATA", Constants.NO_AUTHS, 1);
        bs.fetchColumnFamily(Constants.METADATA_CURRENT_LOCATION_COLUMN_FAMILY);
        Constants.METADATA_PREV_ROW_COLUMN.fetch((ScannerBase)bs);
        bs.setRanges(ranges);
        ScanStats stats = new ScanStats();
        for (int i = 0; i < numLoop; ++i) {
            ScanStat ss = MetadataBatchScanTest.scan(bs, ranges, scanner);
            stats.merge(ss);
        }
        return stats;
    }

    private static ScanStat scan(BatchScanner bs, List<Range> ranges, Scanner scanner) {
        ScanStat ss = new ScanStat();
        long t1 = System.currentTimeMillis();
        int count = 0;
        for (Map.Entry entry : bs) {
            ++count;
        }
        long t2 = System.currentTimeMillis();
        ss.delta1 = t2 - t1;
        ss.count1 = count;
        count = 0;
        t1 = System.currentTimeMillis();
        t2 = System.currentTimeMillis();
        ss.delta2 = t2 - t1;
        ss.count2 = count;
        return ss;
    }

    private static class ScanStats {
        Stat delta1 = new Stat();
        Stat delta2 = new Stat();
        Stat count1 = new Stat();
        Stat count2 = new Stat();

        private ScanStats() {
        }

        void merge(ScanStat ss) {
            this.delta1.addStat(ss.delta1);
            this.delta2.addStat(ss.delta2);
            this.count1.addStat((long)ss.count1);
            this.count2.addStat((long)ss.count2);
        }

        public String toString() {
            return "[" + this.delta1 + "] [" + this.delta2 + "]";
        }
    }

    private static class ScanStat {
        long delta1;
        long delta2;
        int count1;
        int count2;

        private ScanStat() {
        }
    }
}

