/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Random;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.util.AddressUtil;
import org.apache.accumulo.core.util.ServerServices;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.util.TServerUtils;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.accumulo.test.performance.thrift.NullTserver;
import org.apache.accumulo.trace.instrument.Tracer;
import org.apache.accumulo.trace.thrift.TInfo;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;

public class ZombieTServer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        final Logger log = Logger.getLogger(ZombieTServer.class);
        Random random = new Random(System.currentTimeMillis() % 1000L);
        int port = random.nextInt(30000) + 2000;
        Instance instance = HdfsZooInstance.getInstance();
        TransactionWatcher watcher = new TransactionWatcher();
        final ThriftClientHandler tch = new ThriftClientHandler(instance, watcher);
        TabletClientService.Processor processor = new TabletClientService.Processor((TabletClientService.Iface)tch);
        TServerUtils.ServerPort serverPort = TServerUtils.startTServer((int)port, (TProcessor)processor, (String)"ZombieTServer", (String)"walking dead", (int)2, (long)1000L, (long)0xA00000L);
        InetSocketAddress addr = new InetSocketAddress(InetAddress.getLocalHost(), serverPort.port);
        String addressString = AddressUtil.toString((InetSocketAddress)addr);
        String zPath = ZooUtil.getRoot((Instance)instance) + "/tservers" + "/" + addressString;
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        zoo.putPersistentData(zPath, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
        ZooLock zlock = new ZooLock(zPath);
        ZooLock.LockWatcher lw = new ZooLock.LockWatcher(){

            public void lostLock(ZooLock.LockLossReason reason) {
                try {
                    tch.halt(Tracer.traceInfo(), null, null);
                }
                catch (Exception ex) {
                    log.error((Object)ex, (Throwable)ex);
                    System.exit(1);
                }
            }

            public void unableToMonitorLockNode(Throwable e) {
                try {
                    tch.halt(Tracer.traceInfo(), null, null);
                }
                catch (Exception ex) {
                    log.error((Object)ex, (Throwable)ex);
                    System.exit(1);
                }
            }
        };
        byte[] lockContent = new ServerServices(addressString, ServerServices.Service.TSERV_CLIENT).toString().getBytes(Constants.UTF8);
        if (zlock.tryLock(lw, lockContent)) {
            log.debug((Object)("Obtained tablet server lock " + zlock.getLockPath()));
        }
        ThriftClientHandler thriftClientHandler = tch;
        synchronized (thriftClientHandler) {
            while (!tch.halted) {
                ((Object)((Object)tch)).wait();
            }
        }
        System.exit(0);
    }

    public static class ThriftClientHandler
    extends NullTserver.ThriftClientHandler {
        int statusCount = 0;
        boolean halted = false;

        ThriftClientHandler(Instance instance, TransactionWatcher watcher) {
            super(instance, watcher);
        }

        @Override
        public synchronized void fastHalt(TInfo tinfo, TCredentials credentials, String lock) {
            this.halted = true;
            ((Object)((Object)this)).notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TabletServerStatus getTabletServerStatus(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
            ThriftClientHandler thriftClientHandler = this;
            synchronized (thriftClientHandler) {
                if (this.statusCount++ < 1) {
                    TabletServerStatus result = new TabletServerStatus();
                    result.tableMap = new HashMap();
                    return result;
                }
            }
            UtilWaitThread.sleep((long)Integer.MAX_VALUE);
            return null;
        }

        @Override
        public synchronized void halt(TInfo tinfo, TCredentials credentials, String lock) throws ThriftSecurityException, TException {
            this.halted = true;
            ((Object)((Object)this)).notifyAll();
        }
    }
}

