/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.ByteArraySet;
import org.apache.accumulo.test.functional.FunctionalTest;
import org.apache.hadoop.io.Text;

public class VisibilityTest
extends FunctionalTest {
    @Override
    public void cleanup() throws Exception {
    }

    @Override
    public Map<String, String> getInitialConfig() {
        return Collections.emptyMap();
    }

    @Override
    public List<FunctionalTest.TableSetup> getTablesToCreate() {
        return Arrays.asList(new FunctionalTest.TableSetup("vt"), new FunctionalTest.TableSetup("vt2", Collections.singletonMap(Property.TABLE_DEFAULT_SCANTIME_VISIBILITY.getKey(), "DEFLABEL")));
    }

    @Override
    public void run() throws Exception {
        this.insertData();
        this.queryData();
        this.deleteData();
        this.insertDefaultData();
        this.queryDefaultData();
    }

    private static SortedSet<String> nss(String ... labels) {
        TreeSet<String> ts = new TreeSet<String>();
        for (String s : labels) {
            ts.add(s);
        }
        return ts;
    }

    private void mput(Mutation m, String cf, String cq, String cv, String val) {
        ColumnVisibility le = new ColumnVisibility(cv.getBytes(Constants.UTF8));
        m.put(new Text(cf), new Text(cq), le, new Value(val.getBytes(Constants.UTF8)));
    }

    private void mputDelete(Mutation m, String cf, String cq, String cv) {
        ColumnVisibility le = new ColumnVisibility(cv.getBytes(Constants.UTF8));
        m.putDelete(new Text(cf), new Text(cq), le);
    }

    private void insertData() throws Exception {
        BatchWriter bw = this.getConnector().createBatchWriter("vt", new BatchWriterConfig());
        Mutation m1 = new Mutation(new Text("row1"));
        this.mput(m1, "cf1", "cq1", "", "v1");
        this.mput(m1, "cf1", "cq1", "A", "v2");
        this.mput(m1, "cf1", "cq1", "B", "v3");
        this.mput(m1, "cf1", "cq1", "A&B", "v4");
        this.mput(m1, "cf1", "cq1", "A&(L|M)", "v5");
        this.mput(m1, "cf1", "cq1", "B&(L|M)", "v6");
        this.mput(m1, "cf1", "cq1", "A&B&(L|M)", "v7");
        this.mput(m1, "cf1", "cq1", "A&B&(L)", "v8");
        this.mput(m1, "cf1", "cq1", "A&FOO", "v9");
        this.mput(m1, "cf1", "cq1", "A&FOO&(L|M)", "v10");
        this.mput(m1, "cf1", "cq1", "FOO", "v11");
        this.mput(m1, "cf1", "cq1", "(A|B)&FOO&(L|M)", "v12");
        this.mput(m1, "cf1", "cq1", "A&B&(L|M|FOO)", "v13");
        bw.addMutation(m1);
        bw.close();
    }

    private void deleteData() throws Exception {
        BatchWriter bw = this.getConnector().createBatchWriter("vt", new BatchWriterConfig());
        Mutation m1 = new Mutation(new Text("row1"));
        this.mputDelete(m1, "cf1", "cq1", "");
        this.mputDelete(m1, "cf1", "cq1", "A");
        this.mputDelete(m1, "cf1", "cq1", "A&B");
        this.mputDelete(m1, "cf1", "cq1", "B&(L|M)");
        this.mputDelete(m1, "cf1", "cq1", "A&B&(L)");
        this.mputDelete(m1, "cf1", "cq1", "A&FOO&(L|M)");
        this.mputDelete(m1, "cf1", "cq1", "(A|B)&FOO&(L|M)");
        this.mputDelete(m1, "cf1", "cq1", "FOO&A");
        bw.addMutation(m1);
        bw.close();
        HashMap<Set<String>, Set<String>> expected = new HashMap<Set<String>, Set<String>>();
        expected.put(VisibilityTest.nss("A", "L"), VisibilityTest.nss("v5"));
        expected.put(VisibilityTest.nss("A", "M"), VisibilityTest.nss("v5"));
        expected.put(VisibilityTest.nss("B"), VisibilityTest.nss("v3"));
        expected.put(VisibilityTest.nss("Z"), VisibilityTest.nss(new String[0]));
        expected.put(VisibilityTest.nss("A", "B", "L"), VisibilityTest.nss("v7", "v13"));
        expected.put(VisibilityTest.nss("A", "B", "M"), VisibilityTest.nss("v7", "v13"));
        expected.put(VisibilityTest.nss("A", "B", "FOO"), VisibilityTest.nss("v13"));
        expected.put(VisibilityTest.nss("FOO"), VisibilityTest.nss("v11"));
        expected.put(VisibilityTest.nss("A", "FOO"), VisibilityTest.nss("v9"));
        this.queryData(VisibilityTest.nss("A", "B", "FOO", "L", "M", "Z"), VisibilityTest.nss("A", "B", "FOO", "L", "M", "Z"), expected);
    }

    private void insertDefaultData() throws Exception {
        BatchWriter bw = this.getConnector().createBatchWriter("vt2", new BatchWriterConfig());
        Mutation m1 = new Mutation(new Text("row1"));
        this.mput(m1, "cf1", "cq1", "BASE", "v1");
        this.mput(m1, "cf1", "cq2", "DEFLABEL", "v2");
        this.mput(m1, "cf1", "cq3", "", "v3");
        bw.addMutation(m1);
        bw.close();
    }

    private static void uniqueCombos(List<Set<String>> all, Set<String> prefix, Set<String> suffix) {
        all.add(prefix);
        TreeSet<String> ss = new TreeSet<String>(suffix);
        for (String s : suffix) {
            TreeSet<String> ps = new TreeSet<String>(prefix);
            ps.add(s);
            ss.remove(s);
            VisibilityTest.uniqueCombos(all, ps, ss);
        }
    }

    private void queryData() throws Exception {
        HashMap<Set<String>, Set<String>> expected = new HashMap<Set<String>, Set<String>>();
        expected.put(VisibilityTest.nss(new String[0]), VisibilityTest.nss("v1"));
        expected.put(VisibilityTest.nss("A"), VisibilityTest.nss("v2"));
        expected.put(VisibilityTest.nss("A", "L"), VisibilityTest.nss("v5"));
        expected.put(VisibilityTest.nss("A", "M"), VisibilityTest.nss("v5"));
        expected.put(VisibilityTest.nss("B"), VisibilityTest.nss("v3"));
        expected.put(VisibilityTest.nss("B", "L"), VisibilityTest.nss("v6"));
        expected.put(VisibilityTest.nss("B", "M"), VisibilityTest.nss("v6"));
        expected.put(VisibilityTest.nss("Z"), VisibilityTest.nss(new String[0]));
        expected.put(VisibilityTest.nss("A", "B"), VisibilityTest.nss("v4"));
        expected.put(VisibilityTest.nss("A", "B", "L"), VisibilityTest.nss("v7", "v8", "v13"));
        expected.put(VisibilityTest.nss("A", "B", "M"), VisibilityTest.nss("v7", "v13"));
        expected.put(VisibilityTest.nss("A", "B", "FOO"), VisibilityTest.nss("v13"));
        expected.put(VisibilityTest.nss("FOO"), VisibilityTest.nss("v11"));
        expected.put(VisibilityTest.nss("A", "FOO"), VisibilityTest.nss("v9"));
        expected.put(VisibilityTest.nss("A", "FOO", "L"), VisibilityTest.nss("v10", "v12"));
        expected.put(VisibilityTest.nss("A", "FOO", "M"), VisibilityTest.nss("v10", "v12"));
        expected.put(VisibilityTest.nss("B", "FOO", "L"), VisibilityTest.nss("v12"));
        expected.put(VisibilityTest.nss("B", "FOO", "M"), VisibilityTest.nss("v12"));
        this.queryData(VisibilityTest.nss("A", "B", "FOO", "L", "M", "Z"), VisibilityTest.nss("A", "B", "FOO", "L", "M", "Z"), expected);
        this.queryData(VisibilityTest.nss("A", "B", "FOO", "L", "M", "Z"), VisibilityTest.nss("A", "B", "L", "M", "Z"), expected);
        this.queryData(VisibilityTest.nss("A", "B", "FOO", "L", "M", "Z"), VisibilityTest.nss("A", "Z"), expected);
        this.queryData(VisibilityTest.nss("A", "B", "FOO", "L", "M", "Z"), VisibilityTest.nss("Z"), expected);
        this.queryData(VisibilityTest.nss("A", "B", "FOO", "L", "M", "Z"), VisibilityTest.nss(new String[0]), expected);
    }

    private void queryData(Set<String> allAuths, Set<String> userAuths, Map<Set<String>, Set<String>> expected) throws Exception {
        this.getConnector().securityOperations().changeUserAuthorizations(this.getPrincipal(), new Authorizations((Collection)this.nbas(userAuths)));
        ArrayList<Set<String>> combos = new ArrayList<Set<String>>();
        VisibilityTest.uniqueCombos(combos, VisibilityTest.nss(new String[0]), allAuths);
        for (Set<String> set1 : combos) {
            TreeSet<String> e = new TreeSet<String>();
            for (Set<String> set2 : combos) {
                set2 = new HashSet<String>(set2);
                set2.retainAll(userAuths);
                if (!set1.containsAll(set2) || !expected.containsKey(set2)) continue;
                e.addAll((Collection<String>)expected.get(set2));
            }
            set1.retainAll(userAuths);
            this.verify(set1, e);
        }
    }

    private void queryDefaultData() throws Exception {
        this.getConnector().securityOperations().changeUserAuthorizations(this.getPrincipal(), new Authorizations(new String[]{"BASE", "DEFLABEL"}));
        Scanner scanner = this.getConnector().createScanner("vt2", new Authorizations());
        this.verifyDefault(scanner, 0);
        scanner = this.getConnector().createScanner("vt2", new Authorizations(new String[]{"BASE"}));
        this.verifyDefault(scanner, 1);
        scanner = this.getConnector().createScanner("vt2", new Authorizations(new String[]{"BASE", "DEFLABEL"}));
        this.verifyDefault(scanner, 3);
    }

    private void verifyDefault(Scanner scanner, int expectedCount) throws Exception {
        for (Map.Entry entry : scanner) {
            --expectedCount;
        }
        if (expectedCount != 0) {
            throw new Exception(" expected count !=0 " + expectedCount);
        }
    }

    private void verify(Set<String> auths, Set<String> expectedValues) throws Exception {
        ByteArraySet bas = this.nbas(auths);
        try {
            this.verify(bas, expectedValues.toArray(new String[0]));
        }
        catch (Exception e) {
            throw new Exception("Verification failed auths=" + auths + " exp=" + expectedValues, e);
        }
    }

    private ByteArraySet nbas(Set<String> auths) {
        ByteArraySet bas = new ByteArraySet();
        for (String auth : auths) {
            bas.add((Object)auth.getBytes(Constants.UTF8));
        }
        return bas;
    }

    private void verify(ByteArraySet nss, String ... expected) throws Exception {
        Scanner scanner = this.getConnector().createScanner("vt", new Authorizations((Collection)nss));
        this.verify(scanner.iterator(), expected);
        BatchScanner bs = this.getConnector().createBatchScanner("vt", new Authorizations((Collection)nss), 3);
        bs.setRanges(Collections.singleton(new Range()));
        this.verify(bs.iterator(), expected);
        bs.close();
    }

    private void verify(Iterator<Map.Entry<Key, Value>> iter, String ... expected) throws Exception {
        HashSet<String> valuesSeen = new HashSet<String>();
        while (iter.hasNext()) {
            Map.Entry<Key, Value> entry = iter.next();
            if (valuesSeen.contains(entry.getValue().toString())) {
                throw new Exception("Value seen twice");
            }
            valuesSeen.add(entry.getValue().toString());
        }
        for (String ev : expected) {
            if (valuesSeen.remove(ev)) continue;
            throw new Exception("Did not see expected value " + ev);
        }
        if (valuesSeen.size() != 0) {
            throw new Exception("Saw more values than expected " + valuesSeen);
        }
    }
}

