/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TimedOutException;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.test.functional.FunctionalTest;
import org.apache.accumulo.test.functional.SlowConstraint;
import org.apache.accumulo.test.functional.SlowIterator;

public class TimeoutTest
extends FunctionalTest {
    @Override
    public Map<String, String> getInitialConfig() {
        return Collections.emptyMap();
    }

    @Override
    public List<FunctionalTest.TableSetup> getTablesToCreate() {
        return Collections.emptyList();
    }

    @Override
    public void run() throws Exception {
        this.testBatchScannerTimeout();
        this.testBatchWriterTimeout();
    }

    public void testBatchWriterTimeout() throws Exception {
        Connector conn = this.getConnector();
        conn.tableOperations().create("foo1");
        conn.tableOperations().addConstraint("foo1", SlowConstraint.class.getName());
        UtilWaitThread.sleep((long)250L);
        BatchWriter bw = conn.createBatchWriter("foo1", new BatchWriterConfig().setTimeout(3L, TimeUnit.SECONDS));
        Mutation mut = new Mutation((CharSequence)"r1");
        mut.put((CharSequence)"cf1", (CharSequence)"cq1", (CharSequence)"v1");
        bw.addMutation(mut);
        try {
            bw.close();
            throw new Exception("batch writer did not timeout");
        }
        catch (MutationsRejectedException mre) {
            if (!(mre.getCause() instanceof TimedOutException)) {
                throw mre;
            }
            return;
        }
    }

    public void testBatchScannerTimeout() throws Exception {
        this.getConnector().tableOperations().create("timeout");
        BatchWriter bw = this.getConnector().createBatchWriter("timeout", new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)"r1");
        m.put((CharSequence)"cf1", (CharSequence)"cq1", (CharSequence)"v1");
        m.put((CharSequence)"cf1", (CharSequence)"cq2", (CharSequence)"v2");
        m.put((CharSequence)"cf1", (CharSequence)"cq3", (CharSequence)"v3");
        m.put((CharSequence)"cf1", (CharSequence)"cq4", (CharSequence)"v4");
        bw.addMutation(m);
        bw.close();
        BatchScanner bs = this.getConnector().createBatchScanner("timeout", Constants.NO_AUTHS, 2);
        bs.setTimeout(1L, TimeUnit.SECONDS);
        bs.setRanges(Collections.singletonList(new Range()));
        for (Map.Entry entry : bs) {
            entry.getKey();
        }
        IteratorSetting iterSetting = new IteratorSetting(100, SlowIterator.class);
        iterSetting.addOption("sleepTime", "2000");
        this.getConnector().tableOperations().attachIterator("timeout", iterSetting);
        UtilWaitThread.sleep((long)250L);
        try {
            for (Map.Entry entry : bs) {
                entry.getKey();
            }
            throw new Exception("batch scanner did not time out");
        }
        catch (TimedOutException toe) {
            bs.close();
            return;
        }
    }

    @Override
    public void cleanup() throws Exception {
    }
}

