/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.ScannerImpl;
import org.apache.accumulo.core.client.impl.Writer;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.util.ColumnFQ;
import org.apache.accumulo.core.util.MetadataTable;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.master.state.Assignment;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.security.SecurityConstants;
import org.apache.accumulo.server.tabletserver.TabletServer;
import org.apache.accumulo.server.util.MetadataTable;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.accumulo.test.functional.FunctionalTest;
import org.apache.hadoop.io.Text;

public class SplitRecoveryTest
extends FunctionalTest {
    @Override
    public void cleanup() throws Exception {
    }

    @Override
    public Map<String, String> getInitialConfig() {
        return Collections.emptyMap();
    }

    @Override
    public List<FunctionalTest.TableSetup> getTablesToCreate() {
        return Collections.emptyList();
    }

    private KeyExtent nke(String table, String endRow, String prevEndRow) {
        return new KeyExtent(new Text(table), endRow == null ? null : new Text(endRow), prevEndRow == null ? null : new Text(prevEndRow));
    }

    @Override
    public void run() throws Exception {
        String zPath = ZooUtil.getRoot((Instance)HdfsZooInstance.getInstance()) + "/testLock";
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        zoo.putPersistentData(zPath, new byte[0], ZooUtil.NodeExistsPolicy.OVERWRITE);
        ZooLock zl = new ZooLock(zPath);
        boolean gotLock = zl.tryLock(new ZooLock.LockWatcher(){

            public void lostLock(ZooLock.LockLossReason reason) {
                System.exit(-1);
            }

            public void unableToMonitorLockNode(Throwable e) {
                System.exit(-1);
            }
        }, "foo".getBytes(Constants.UTF8));
        if (!gotLock) {
            System.err.println("Failed to get lock " + zPath);
        }
        this.runSplitRecoveryTest(0, "sp", 0, zl, this.nke("foo0", null, null));
        this.runSplitRecoveryTest(1, "sp", 0, zl, this.nke("foo1", null, null));
        this.runSplitRecoveryTest(0, "k", 0, zl, this.nke("foo2", "m", null), this.nke("foo2", null, "m"));
        this.runSplitRecoveryTest(1, "k", 0, zl, this.nke("foo3", "m", null), this.nke("foo3", null, "m"));
        this.runSplitRecoveryTest(0, "o", 1, zl, this.nke("foo4", "m", null), this.nke("foo4", null, "m"));
        this.runSplitRecoveryTest(1, "o", 1, zl, this.nke("foo5", "m", null), this.nke("foo5", null, "m"));
        this.runSplitRecoveryTest(0, "o", 1, zl, this.nke("foo6", "m", null), this.nke("foo6", "r", "m"), this.nke("foo6", null, "r"));
        this.runSplitRecoveryTest(1, "o", 1, zl, this.nke("foo7", "m", null), this.nke("foo7", "r", "m"), this.nke("foo7", null, "r"));
        this.runSplitRecoveryTest(0, "g", 0, zl, this.nke("foo8", "m", null), this.nke("foo8", "r", "m"), this.nke("foo8", null, "r"));
        this.runSplitRecoveryTest(1, "g", 0, zl, this.nke("foo9", "m", null), this.nke("foo9", "r", "m"), this.nke("foo9", null, "r"));
        this.runSplitRecoveryTest(0, "w", 2, zl, this.nke("fooa", "m", null), this.nke("fooa", "r", "m"), this.nke("fooa", null, "r"));
        this.runSplitRecoveryTest(1, "w", 2, zl, this.nke("foob", "m", null), this.nke("foob", "r", "m"), this.nke("foob", null, "r"));
    }

    private void runSplitRecoveryTest(int failPoint, String mr, int extentToSplit, ZooLock zl, KeyExtent ... extents) throws Exception {
        Text midRow = new Text(mr);
        TreeMap<String, MetadataTable.DataFileValue> splitMapFiles = null;
        for (int i = 0; i < extents.length; ++i) {
            KeyExtent extent = extents[i];
            String tdir = "/dir_" + i;
            MetadataTable.addTablet((KeyExtent)extent, (String)tdir, (TCredentials)SecurityConstants.getSystemCredentials(), (char)'L', (ZooLock)zl);
            TreeMap<String, MetadataTable.DataFileValue> mapFiles = new TreeMap<String, MetadataTable.DataFileValue>();
            mapFiles.put(tdir + "/" + "rf" + "_000_000", new MetadataTable.DataFileValue((long)(1000017 + i), (long)(10000 + i)));
            if (i == extentToSplit) {
                splitMapFiles = mapFiles;
            }
            int tid = 0;
            TransactionWatcher.ZooArbitrator.start((String)"bulkTx", (long)tid);
            MetadataTable.updateTabletDataFile((long)tid, (KeyExtent)extent, mapFiles, (String)"L0", (TCredentials)SecurityConstants.getSystemCredentials(), (ZooLock)zl);
        }
        KeyExtent extent = extents[extentToSplit];
        KeyExtent high = new KeyExtent(extent.getTableId(), extent.getEndRow(), midRow);
        KeyExtent low = new KeyExtent(extent.getTableId(), midRow, extent.getPrevEndRow());
        this.splitPartiallyAndRecover(extent, high, low, 0.4, splitMapFiles, midRow, "localhost:1234", failPoint, zl);
    }

    private void splitPartiallyAndRecover(KeyExtent extent, KeyExtent high, KeyExtent low, double splitRatio, SortedMap<String, MetadataTable.DataFileValue> mapFiles, Text midRow, String location, int steps, ZooLock zl) throws Exception {
        TreeMap<String, MetadataTable.DataFileValue> lowDatafileSizes = new TreeMap<String, MetadataTable.DataFileValue>();
        TreeMap<String, MetadataTable.DataFileValue> highDatafileSizes = new TreeMap<String, MetadataTable.DataFileValue>();
        ArrayList highDatafilesToRemove = new ArrayList();
        MetadataTable.splitDatafiles((Text)extent.getTableId(), (Text)midRow, (double)splitRatio, new HashMap(), mapFiles, lowDatafileSizes, highDatafileSizes, highDatafilesToRemove);
        MetadataTable.splitTablet((KeyExtent)high, (Text)extent.getPrevEndRow(), (double)splitRatio, (TCredentials)SecurityConstants.getSystemCredentials(), (ZooLock)zl);
        TServerInstance instance = new TServerInstance(location, zl.getSessionId());
        Writer writer = new Writer(HdfsZooInstance.getInstance(), SecurityConstants.getSystemCredentials(), "!0");
        Assignment assignment = new Assignment(high, instance);
        Mutation m = new Mutation(assignment.tablet.getMetadataEntry());
        m.put(Constants.METADATA_FUTURE_LOCATION_COLUMN_FAMILY, assignment.server.asColumnQualifier(), assignment.server.asMutationValue());
        writer.update(m);
        if (steps >= 1) {
            Map bulkFiles = MetadataTable.getBulkFilesLoaded((TCredentials)SecurityConstants.getSystemCredentials(), (KeyExtent)extent);
            MetadataTable.addNewTablet((KeyExtent)low, (String)"/lowDir", (TServerInstance)instance, lowDatafileSizes, (Map)bulkFiles, (TCredentials)SecurityConstants.getSystemCredentials(), (String)"L0", (long)-1L, (long)-1L, (ZooLock)zl);
        }
        if (steps >= 2) {
            MetadataTable.finishSplit((KeyExtent)high, highDatafileSizes, highDatafilesToRemove, (TCredentials)SecurityConstants.getSystemCredentials(), (ZooLock)zl);
        }
        TabletServer.verifyTabletInformation((KeyExtent)high, (TServerInstance)instance, null, (String)"127.0.0.1:0", (ZooLock)zl);
        if (steps >= 1) {
            this.ensureTabletHasNoUnexpectedMetadataEntries(low, lowDatafileSizes);
            this.ensureTabletHasNoUnexpectedMetadataEntries(high, highDatafileSizes);
            Map lowBulkFiles = MetadataTable.getBulkFilesLoaded((TCredentials)SecurityConstants.getSystemCredentials(), (KeyExtent)low);
            Map highBulkFiles = MetadataTable.getBulkFilesLoaded((TCredentials)SecurityConstants.getSystemCredentials(), (KeyExtent)high);
            if (!((Object)lowBulkFiles).equals(highBulkFiles)) {
                throw new Exception(" " + lowBulkFiles + " != " + highBulkFiles + " " + low + " " + high);
            }
            if (lowBulkFiles.size() == 0) {
                throw new Exception(" no bulk files " + low);
            }
        } else {
            this.ensureTabletHasNoUnexpectedMetadataEntries(extent, mapFiles);
        }
    }

    private void ensureTabletHasNoUnexpectedMetadataEntries(KeyExtent extent, SortedMap<String, MetadataTable.DataFileValue> expectedMapFiles) throws Exception {
        ScannerImpl scanner = new ScannerImpl(HdfsZooInstance.getInstance(), SecurityConstants.getSystemCredentials(), "!0", Constants.NO_AUTHS);
        scanner.setRange(extent.toMetadataRange());
        HashSet<ColumnFQ> expectedColumns = new HashSet<ColumnFQ>();
        expectedColumns.add(Constants.METADATA_DIRECTORY_COLUMN);
        expectedColumns.add(Constants.METADATA_PREV_ROW_COLUMN);
        expectedColumns.add(Constants.METADATA_TIME_COLUMN);
        expectedColumns.add(Constants.METADATA_LOCK_COLUMN);
        HashSet<Text> expectedColumnFamilies = new HashSet<Text>();
        expectedColumnFamilies.add(Constants.METADATA_DATAFILE_COLUMN_FAMILY);
        expectedColumnFamilies.add(Constants.METADATA_FUTURE_LOCATION_COLUMN_FAMILY);
        expectedColumnFamilies.add(Constants.METADATA_CURRENT_LOCATION_COLUMN_FAMILY);
        expectedColumnFamilies.add(Constants.METADATA_LAST_LOCATION_COLUMN_FAMILY);
        expectedColumnFamilies.add(Constants.METADATA_BULKFILE_COLUMN_FAMILY);
        Iterator iter = scanner.iterator();
        while (iter.hasNext()) {
            Key key = (Key)((Map.Entry)iter.next()).getKey();
            if (!key.getRow().equals((Object)extent.getMetadataEntry())) {
                throw new Exception("Tablet " + extent + " contained unexpected " + "!METADATA" + " entry " + key);
            }
            if (expectedColumnFamilies.contains(key.getColumnFamily()) || expectedColumns.remove(new ColumnFQ(key))) continue;
            throw new Exception("Tablet " + extent + " contained unexpected " + "!METADATA" + " entry " + key);
        }
        System.out.println("expectedColumns " + expectedColumns);
        if (expectedColumns.size() > 1 || expectedColumns.size() == 1) {
            throw new Exception("Not all expected columns seen " + extent + " " + expectedColumns);
        }
        SortedMap fixedMapFiles = MetadataTable.getDataFileSizes((KeyExtent)extent, (TCredentials)SecurityConstants.getSystemCredentials());
        this.verifySame(expectedMapFiles, fixedMapFiles);
    }

    private void verifySame(SortedMap<String, MetadataTable.DataFileValue> datafileSizes, SortedMap<String, MetadataTable.DataFileValue> fixedDatafileSizes) throws Exception {
        if (!datafileSizes.keySet().containsAll(fixedDatafileSizes.keySet()) || !fixedDatafileSizes.keySet().containsAll(datafileSizes.keySet())) {
            throw new Exception("Key sets not the same " + datafileSizes.keySet() + " !=  " + fixedDatafileSizes.keySet());
        }
        for (Map.Entry<String, MetadataTable.DataFileValue> entry : datafileSizes.entrySet()) {
            MetadataTable.DataFileValue otherDfv;
            MetadataTable.DataFileValue dfv = entry.getValue();
            if (dfv.equals((Object)(otherDfv = (MetadataTable.DataFileValue)fixedDatafileSizes.get(entry.getKey())))) continue;
            throw new Exception(entry.getKey() + " dfv not equal  " + dfv + "  " + otherDfv);
        }
    }
}

