/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.test.functional.FunctionalTest;
import org.apache.hadoop.io.Text;

public class SparseColumnFamilyTest
extends FunctionalTest {
    @Override
    public Map<String, String> getInitialConfig() {
        return Collections.emptyMap();
    }

    @Override
    public List<FunctionalTest.TableSetup> getTablesToCreate() {
        return Collections.emptyList();
    }

    @Override
    public void run() throws Exception {
        int i;
        this.getConnector().tableOperations().create("scftt");
        BatchWriter bw = this.getConnector().createBatchWriter("scftt", new BatchWriterConfig());
        bw.addMutation(this.nm(0, 1, 0));
        for (i = 1; i < 99999; ++i) {
            bw.addMutation(this.nm(i * 2, 0, i));
        }
        bw.addMutation(this.nm(199998, 1, 99999));
        bw.flush();
        this.getConnector().tableOperations().flush("scftt", null, null, true);
        for (i = 0; i < 100000; ++i) {
            bw.addMutation(this.nm(i * 2 + 1, i % 2 == 0 ? 0 : 1, i));
        }
        bw.close();
        this.getConnector().tableOperations().flush("scftt", null, null, true);
        Scanner scanner = this.getConnector().createScanner("scftt", Constants.NO_AUTHS);
        for (int i2 = 0; i2 < 200; ++i2) {
            Map.Entry entry;
            scanner.setRange(new Range((CharSequence)String.format("%06d", i2), null));
            scanner.clearColumns();
            scanner.setBatchSize(3);
            scanner.fetchColumnFamily(new Text(String.format("%03d", 1)));
            long t1 = System.currentTimeMillis();
            Iterator iter = scanner.iterator();
            if (iter.hasNext() && !"001".equals(((Key)(entry = (Map.Entry)iter.next()).getKey()).getColumnFamilyData().toString())) {
                throw new Exception();
            }
            long t2 = System.currentTimeMillis();
            System.out.println("time " + (t2 - t1));
        }
    }

    private Mutation nm(int row, int cf, int val) {
        Mutation m = new Mutation((CharSequence)String.format("%06d", row));
        m.put((CharSequence)String.format("%03d", cf), (CharSequence)"", (CharSequence)("" + val));
        return m;
    }

    @Override
    public void cleanup() throws Exception {
    }
}

